/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.economy;

import io.github.tehstoneman.cashcraft.api.CashCraftAPI;
import io.github.tehstoneman.cashcraft.api.IPlayerWallet;
import io.github.tehstoneman.cashcraft.common.item.ItemCash;
import io.github.tehstoneman.cashcraft.common.item.ItemCashCraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

class PlayerWallet
implements IPlayerWallet {
    private long amount = 0L;
    private final EntityPlayer player;

    PlayerWallet(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        for (ItemStack itemStack : inventory.field_70462_a) {
            this.amount += CashCraftAPI.economy.getValue(itemStack);
        }
        this.player = player;
    }

    @Override
    public long getValue() {
        return this.amount;
    }

    @Override
    public void setValue(long value) {
        this.empty();
        this.deposit(value);
    }

    @Override
    public void deposit(long value) {
        this.amount += value;
        while (value > 0L) {
            ItemStack stackCash = CashCraftAPI.economy.getCash(value);
            value -= CashCraftAPI.economy.getValue(stackCash);
        }
    }

    @Override
    public boolean withdraw(long value) {
        if (this.amount < value) {
            return false;
        }
        for (int cashValue = ItemCash.EnumCoinValue.values().length; cashValue > 0; --cashValue) {
            for (int i = 0; i < this.player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack itemStack = (ItemStack)this.player.field_71071_by.field_70462_a.get(i);
                if (itemStack == null || itemStack.func_77973_b() != ItemCashCraft.COIN || itemStack.func_77952_i() != cashValue - 1) continue;
                int count = (int)(value / (long)ItemCash.EnumCoinValue.byMetadata(cashValue - 1).getValue());
                if (itemStack.func_190916_E() <= count) {
                    count = itemStack.func_190916_E();
                    this.player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                } else {
                    this.player.field_71071_by.func_70298_a(i, count);
                }
                value -= (long)(ItemCash.EnumCoinValue.byMetadata(cashValue - 1).getValue() * count);
            }
        }
        return false;
    }

    @Override
    public void empty() {
        InventoryPlayer inventory = this.player.field_71071_by;
        for (int i = 0; i < inventory.field_70462_a.size(); ++i) {
            ItemStack itemStack = (ItemStack)inventory.field_70462_a.get(i);
            if (itemStack == null || itemStack.func_77973_b() != ItemCashCraft.COIN) continue;
            inventory.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
        this.amount = 0L;
    }

    @Override
    public String toString() {
        return CashCraftAPI.economy.toString(this.amount);
    }
}

