/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.network;

import io.github.tehstoneman.cashcraft.config.CashCraftConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SyncConfigMessage
implements IMessage {
    private boolean showAsCoins;
    private boolean useCustomName;
    private String cashSingular;
    private String cashPlural;

    public SyncConfigMessage() {
        this.showAsCoins = CashCraftConfig.showAsCoins;
        this.useCustomName = CashCraftConfig.useCustomName;
        this.cashSingular = CashCraftConfig.cashSingular;
        this.cashPlural = CashCraftConfig.cashPlural;
    }

    public SyncConfigMessage(boolean showAsCoins, boolean useCustomName, String cashSingular, String cashPlural) {
        this.showAsCoins = showAsCoins;
        this.useCustomName = useCustomName;
        this.cashSingular = cashSingular;
        this.cashPlural = cashPlural;
    }

    public void fromBytes(ByteBuf buf) {
        this.showAsCoins = buf.readBoolean();
        this.useCustomName = buf.readBoolean();
        if (this.useCustomName) {
            this.cashSingular = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.cashPlural = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.showAsCoins);
        buf.writeBoolean(this.useCustomName);
        if (this.useCustomName) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.cashSingular);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.cashPlural);
        }
    }

    public static class Handler
    implements IMessageHandler<SyncConfigMessage, IMessage> {
        public IMessage onMessage(final SyncConfigMessage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft minecraft = Minecraft.func_71410_x();
                final WorldClient worldClient = minecraft.field_71441_e;
                minecraft.func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        this.processMessage(worldClient, message);
                    }
                });
            }
            return null;
        }

        void processMessage(WorldClient worldClient, SyncConfigMessage message) {
            CashCraftConfig.showAsCoins = message.showAsCoins;
            CashCraftConfig.useCustomName = message.useCustomName;
            CashCraftConfig.cashSingular = message.cashSingular;
            CashCraftConfig.cashPlural = message.cashPlural;
        }
    }
}

