/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class CashCraftConfig {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static Common COMMON = new Common(COMMON_BUILDER);
    private static ForgeConfigSpec COMMON_SPEC = COMMON_BUILDER.build();

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, COMMON_SPEC);
    }

    public static class Common {
        public ForgeConfigSpec.BooleanValue makeChange;
        public ForgeConfigSpec.BooleanValue useEconomy;
        public ForgeConfigSpec.BooleanValue doMobDrops;
        public ForgeConfigSpec.BooleanValue showAsCoins;
        public ForgeConfigSpec.BooleanValue useCustomName;
        public ForgeConfigSpec.ConfigValue<String> cashSingular;
        public ForgeConfigSpec.ConfigValue<String> cashPlural;
        public ForgeConfigSpec.BooleanValue useTrade;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings.").push("General");
            this.makeChange = builder.translation("config.cashcraft.make_change").define("makeChange", true);
            this.useEconomy = builder.translation("config.cashcraft.use_economy").define("useEconomy", true);
            this.doMobDrops = builder.translation("config.cashcraft.mob_drops").define("doMobDrops", true);
            builder.pop();
            builder.comment("Display settings.").push("Display");
            this.showAsCoins = builder.translation("config.cashcraft.show_as_coins").define("showAsCoins", true);
            this.useCustomName = builder.translation("config.cashcraft.use_custom_name").define("useCustomName", true);
            this.cashSingular = builder.translation("config.cashcraft.cash_singular").define("cashSingular", (Object)"%s cash");
            this.cashPlural = builder.translation("config.cashcraft.cash_plural").define("cashPlural", (Object)"%s cash");
            builder.pop();
            builder.comment("Economy settings.").push("Economy");
            this.useTrade = builder.translation("config.cashcraft.show_as_coins").define("use_trade", true);
            builder.pop();
        }
    }
}

