/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.economy;

import io.github.tehstoneman.cashcraft.api.IEcomomy;
import io.github.tehstoneman.cashcraft.common.item.ItemCash;
import io.github.tehstoneman.cashcraft.config.CashCraftConfig;
import io.github.tehstoneman.cashcraft.economy.PlayerWallet;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Economy
implements IEcomomy {
    @Override
    public Boolean isEnabled() {
        return (Boolean)CashCraftConfig.COMMON.useEconomy.get();
    }

    @Override
    public PlayerWallet getWallet(PlayerEntity player) {
        if (player != null) {
            return new PlayerWallet(player);
        }
        return null;
    }

    @Override
    public String getCurrencyName(boolean plural, boolean longFormat) {
        if (plural) {
            if (!((Boolean)CashCraftConfig.COMMON.useCustomName.get()).booleanValue()) {
                if (longFormat) {
                    if (((Boolean)CashCraftConfig.COMMON.showAsCoins.get()).booleanValue()) {
                        return "economy.cashcraft.coin_plural.long";
                    }
                    return "economy.cashcraft.cash_plural.long";
                }
                if (((Boolean)CashCraftConfig.COMMON.showAsCoins.get()).booleanValue()) {
                    return "economy.cashcraft.coin_plural.short";
                }
                return "economy.cashcraft.cash_plural.short";
            }
            return (String)CashCraftConfig.COMMON.cashPlural.get();
        }
        if (!((Boolean)CashCraftConfig.COMMON.useCustomName.get()).booleanValue()) {
            if (longFormat) {
                if (((Boolean)CashCraftConfig.COMMON.showAsCoins.get()).booleanValue()) {
                    return "economy.cashcraft.coin_singular.long";
                }
                return "economy.cashcraft.cash_singular.long";
            }
            if (((Boolean)CashCraftConfig.COMMON.showAsCoins.get()).booleanValue()) {
                return "economy.cashcraft.coin_singular.short";
            }
            return "economy.cashcraft.cash_singular.short";
        }
        return (String)CashCraftConfig.COMMON.cashSingular.get();
    }

    @Override
    public ItemStack getCash(long amount) {
        return ItemStack.field_190927_a;
    }

    @Override
    public long getValue(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemCash) {
            int count = itemStack.func_190916_E();
            int value = ((ItemCash)item).getValue();
            return count * value;
        }
        return 0L;
    }

    @Override
    public String toString(long amount) {
        return this.toString(amount, false);
    }

    @Override
    public String toString(long amount, boolean longFormat) {
        if (((Boolean)CashCraftConfig.COMMON.showAsCoins.get()).booleanValue()) {
            return I18n.func_135052_a((String)this.getCurrencyName(amount != 1L, longFormat), (Object[])new Object[]{String.format("%d", amount)});
        }
        long numerator = amount / 100L;
        long demoninator = amount % 100L;
        return I18n.func_135052_a((String)this.getCurrencyName(numerator != 1L, longFormat), (Object[])new Object[]{String.format("%d.%02d", numerator, demoninator)});
    }
}

