/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.economy;

import io.github.tehstoneman.cashcraft.api.CashCraftAPI;
import io.github.tehstoneman.cashcraft.api.IPlayerWallet;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;

class PlayerWallet
implements IPlayerWallet {
    private long amount = 0L;
    private final PlayerEntity player;

    PlayerWallet(PlayerEntity player) {
        PlayerInventory inventory = player.field_71071_by;
        for (ItemStack itemStack : inventory.field_70462_a) {
            this.amount += CashCraftAPI.economy.getValue(itemStack);
        }
        this.player = player;
    }

    @Override
    public long getValue() {
        return this.amount;
    }

    @Override
    public void setValue(long value) {
        this.empty();
        this.deposit(value);
    }

    @Override
    public void deposit(long value) {
        this.amount += value;
        while (value > 0L) {
            ItemStack stackCash = CashCraftAPI.economy.getCash(value);
            value -= CashCraftAPI.economy.getValue(stackCash);
        }
    }

    @Override
    public boolean withdraw(long value) {
        if (this.amount < value) {
            return false;
        }
        return false;
    }

    @Override
    public void empty() {
        PlayerInventory inventory = this.player.field_71071_by;
        this.amount = 0L;
    }

    @Override
    public String toString() {
        return CashCraftAPI.economy.toString(this.amount);
    }
}

