/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.github.tehstoneman.cashcraft.CashCraft;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;

public class ItemCash
extends Item {
    private IIcon[] icons;

    public ItemCash() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        int j = MathHelper.func_76125_a((int)damage, (int)0, (int)15);
        return this.icons[j];
    }

    public String func_77667_c(ItemStack itemStack) {
        int metadata = itemStack.func_77960_j();
        EnumCoinValue values = EnumCoinValue.byMetadata(metadata);
        return super.func_77658_a() + "." + values.getName();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subItems) {
        for (EnumCoinValue values : EnumCoinValue.values()) {
            int metadata = values.getMetadata();
            ItemStack subItemStack = new ItemStack(item, 1, metadata);
            subItems.add(subItemStack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[EnumCoinValue.values().length];
        for (int i = 0; i < EnumCoinValue.values().length; ++i) {
            EnumCoinValue values = EnumCoinValue.byMetadata(i);
            this.icons[i] = register.func_94245_a(CashCraft.modAsset(this.func_111208_A() + "_" + values.getTextureName()));
        }
    }

    public static enum EnumCoinValue {
        COIN_ONE(0, 1, "coin.one", "coin_001"),
        COIN_TWO(1, 2, "coin.two", "coin_002"),
        COIN_FOUR(2, 4, "coin.four", "coin_004"),
        COIN_EIGHT(3, 8, "coin.eight", "coin_008"),
        COIN_SIXTEEN(4, 16, "coin.sixteen", "coin_016"),
        COIN_THIRTY_TWO(5, 32, "coin.thirtyTwo", "coin_032"),
        COIN_SIXTY_FOUR(6, 64, "coin.sixtyFour", "coin_064"),
        NOTE_ONE(7, 128, "note.one", "note_001"),
        NOTE_TWO(8, 256, "note.two", "note_002"),
        NOTE_FOUR(9, 512, "note.four", "note_004"),
        NOTE_EIGHT(10, 1024, "note.eight", "note_008"),
        NOTE_SIXTEEN(11, 2048, "note.sixteen", "note_016"),
        NOTE_THIRTY_TWO(12, 4096, "note.thirtyTwo", "note_032"),
        NOTE_SIXTY_FOUR(13, 8192, "note.sixtyFour", "note_064"),
        NOTE_ONE_TWO_EIGHT(14, 16384, "note.oneTwoEight", "note_128");

        private int meta;
        private int value;
        private String name;
        private String icon;
        private static final EnumCoinValue[] META_LOOKUP;

        private EnumCoinValue(int meta, int value, String name, String icon) {
            this.meta = meta;
            this.value = value;
            this.name = name;
            this.icon = icon;
        }

        public static EnumCoinValue byMetadata(int metadata) {
            if (metadata < 0 || metadata >= META_LOOKUP.length) {
                metadata = 0;
            }
            return META_LOOKUP[metadata];
        }

        public int getMetadata() {
            return this.meta;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String getTextureName() {
            return this.icon;
        }

        static {
            META_LOOKUP = new EnumCoinValue[EnumCoinValue.values().length];
            EnumCoinValue[] arr$ = EnumCoinValue.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                EnumCoinValue value;
                EnumCoinValue.META_LOOKUP[value.getMetadata()] = value = arr$[i$];
            }
        }
    }
}

