/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.common.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCash
extends Item {
    public ItemCash() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack itemStack) {
        int metadata = itemStack.func_77952_i();
        EnumCoinValue values = EnumCoinValue.byMetadata(metadata);
        return super.func_77658_a() + "." + values.getName();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subItems) {
        for (EnumCoinValue values : EnumCoinValue.values()) {
            int metadata = values.getMetadata();
            ItemStack subItemStack = new ItemStack(item, 1, metadata);
            subItems.add(subItemStack);
        }
    }

    public int getValue() {
        return this.getValue(new ItemStack((Item)this));
    }

    public int getValue(ItemStack itemStack) {
        int metadata = itemStack.func_77952_i();
        EnumCoinValue values = EnumCoinValue.byMetadata(metadata);
        return values.getValue();
    }

    public static enum EnumCoinValue {
        COIN_ONE(0, 1, "coin.one", "coin_001"),
        COIN_TWO(1, 2, "coin.two", "coin_002"),
        COIN_FIVE(2, 5, "coin.five", "coin_005"),
        COIN_TEN(3, 10, "coin.ten", "coin_010"),
        COIN_TWENTY(4, 20, "coin.twenty", "coin_020"),
        COIN_FIFTY(5, 50, "coin.fifty", "coin_050"),
        NOTE_ONE(6, 100, "note.one", "note_001"),
        NOTE_TWO(7, 200, "note.two", "note_002"),
        NOTE_FIVE(8, 500, "note.five", "note_005"),
        NOTE_TEN(9, 1000, "note.ten", "note_010"),
        NOTE_TWENTY(10, 2000, "note.twenty", "note_020"),
        NOTE_FIFTY(11, 5000, "note.fifty", "note_050"),
        NOTE_HUNDRED(12, 10000, "note.hundred", "note_100");

        private int meta;
        private int value;
        private String name;
        private String icon;
        private static final EnumCoinValue[] META_LOOKUP;

        private EnumCoinValue(int meta, int value, String name, String icon) {
            this.meta = meta;
            this.value = value;
            this.name = name;
            this.icon = icon;
        }

        public static EnumCoinValue byMetadata(int metadata) {
            if (metadata < 0 || metadata >= META_LOOKUP.length) {
                metadata = 0;
            }
            return META_LOOKUP[metadata];
        }

        public int getMetadata() {
            return this.meta;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String getTextureName() {
            return "cash_" + this.icon;
        }

        static {
            META_LOOKUP = new EnumCoinValue[EnumCoinValue.values().length];
            EnumCoinValue[] enumCoinValueArray = EnumCoinValue.values();
            int n = enumCoinValueArray.length;
            for (int i = 0; i < n; ++i) {
                EnumCoinValue value;
                EnumCoinValue.META_LOOKUP[value.getMetadata()] = value = enumCoinValueArray[i];
            }
        }
    }
}

