/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.economy;

import io.github.tehstoneman.cashcraft.api.IEcomomy;
import io.github.tehstoneman.cashcraft.common.item.CashCraftItems;
import io.github.tehstoneman.cashcraft.common.item.ItemCash;
import io.github.tehstoneman.cashcraft.economy.PlayerWallet;
import io.github.tehstoneman.cashcraft.util.ModSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Economy
implements IEcomomy {
    @Override
    public Boolean isEnabled() {
        return ModSettings.useEconomy;
    }

    @Override
    public PlayerWallet getWallet(EntityPlayer player) {
        if (player != null) {
            return new PlayerWallet(player);
        }
        return null;
    }

    @Override
    public String currency(long amount, boolean longFormat) {
        if (amount == 1L) {
            return ModSettings.cashSingular;
        }
        return ModSettings.cashPlural;
    }

    @Override
    public ItemStack getCash(long amount) {
        int i = ItemCash.EnumCoinValue.values().length - 1;
        while ((long)ItemCash.EnumCoinValue.byMetadata(i).getValue() > amount) {
            --i;
        }
        int count = (int)(amount / (long)ItemCash.EnumCoinValue.byMetadata(i).getValue());
        return new ItemStack((Item)CashCraftItems.itemCoin, count, i);
    }

    @Override
    public long getValue(ItemStack itemStack) {
        int count = itemStack.field_77994_a;
        int value = ItemCash.EnumCoinValue.byMetadata(itemStack.func_77952_i()).getValue();
        return count * value;
    }

    @Override
    public String toString(long amount) {
        return this.toString(amount, false);
    }

    @Override
    public String toString(long amount, boolean longFormat) {
        if (ModSettings.showAsCoins) {
            return Long.toString(amount) + " " + this.currency(amount, longFormat);
        }
        long numerator = amount / 128L;
        long demoninator = amount % 128L;
        return Long.toString(numerator) + "." + Long.toString(demoninator) + " " + this.currency(numerator, longFormat);
    }
}

