/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.economy;

import io.github.tehstoneman.cashcraft.api.CashCraftAPI;
import io.github.tehstoneman.cashcraft.api.IPlayerWallet;
import io.github.tehstoneman.cashcraft.item.CashCraftItems;
import io.github.tehstoneman.cashcraft.item.ItemCash;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class PlayerWallet
implements IPlayerWallet {
    private long amount = 0L;
    private final EntityPlayer player;

    public PlayerWallet(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        for (ItemStack itemStack : inventory.field_70462_a) {
            this.amount += CashCraftAPI.economy.getValue(itemStack);
        }
        this.player = player;
    }

    @Override
    public long getValue() {
        return this.amount;
    }

    @Override
    public void setValue(long value) {
        this.empty();
        this.deposit(value);
    }

    @Override
    public void deposit(long value) {
        this.amount += value;
        while (value > 0L) {
            ItemStack stackCash = CashCraftAPI.economy.getCash(value);
            EntityItem entityitem = this.player.func_71019_a(stackCash, false);
            value -= CashCraftAPI.economy.getValue(stackCash);
        }
    }

    @Override
    public boolean withdraw(long value) {
        if (this.amount < value) {
            return false;
        }
        for (int cashValue = ItemCash.EnumCoinValue.values().length; cashValue > 0; --cashValue) {
            for (int i = 0; i < this.player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack itemStack = this.player.field_71071_by.field_70462_a[i];
                if (itemStack == null || itemStack.func_77973_b() != CashCraftItems.itemCoin || itemStack.func_77952_i() != cashValue - 1) continue;
                int count = (int)(value / (long)ItemCash.EnumCoinValue.byMetadata(cashValue - 1).getValue());
                if (itemStack.field_77994_a <= count) {
                    count = itemStack.field_77994_a;
                    this.player.field_71071_by.field_70462_a[i] = null;
                } else {
                    this.player.field_71071_by.field_70462_a[i].field_77994_a -= count;
                }
                value -= (long)(ItemCash.EnumCoinValue.byMetadata(cashValue - 1).getValue() * count);
            }
        }
        return false;
    }

    @Override
    public void empty() {
        InventoryPlayer inventory = this.player.field_71071_by;
        for (int i = 0; i < inventory.field_70462_a.length; ++i) {
            ItemStack itemStack = inventory.field_70462_a[i];
            if (itemStack == null || itemStack.func_77973_b() != CashCraftItems.itemCoin) continue;
            inventory.field_70462_a[i] = null;
        }
        this.amount = 0L;
    }

    @Override
    public String toString() {
        return CashCraftAPI.economy.toString(this.amount);
    }
}

