/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.layer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3545;
import supercoder79.cavebiomes.cave.CaveDecorator;
import supercoder79.cavebiomes.cave.CaveDecorators;
import supercoder79.cavebiomes.layer.CaveInitLayer;
import supercoder79.cavebiomes.layer.CaveLayer;
import supercoder79.cavebiomes.layer.OreLayer;
import supercoder79.cavebiomes.layer.RandomStoneLayer;
import supercoder79.cavebiomes.layer.RareCaveLayer;
import supercoder79.cavebiomes.layer.VoronoiAccess;
import supercoder79.cavebiomes.magic.LayerRandom;

public class LayerHolder {
    static final List<CaveDecorator> BASE_DECORATOR_LIST = new ArrayList<CaveDecorator>();
    static final List<CaveDecorator> MASTER_DECORATOR_LIST = new ArrayList<CaveDecorator>();
    private static final CaveLayer INIT_LAYER;
    private static final CaveLayer STONE_LAYER;
    private static final CaveLayer RARE_CAVE_LAYER;
    private static final CaveLayer ORE_LAYER;

    public static CaveDecorator getDecorator(long worldSeed, int x, int z) {
        class_3545<Integer, Integer> pair = VoronoiAccess.getVoronoi(worldSeed, x >> 2, 0, z >> 2);
        return MASTER_DECORATOR_LIST.get(LayerHolder.operate(new LayerRandom(worldSeed), (Integer)pair.method_15442(), (Integer)pair.method_15441()));
    }

    private static int operate(LayerRandom random, int x, int z) {
        int sample = INIT_LAYER.operate(random, 0, x, z);
        sample = STONE_LAYER.operate(random, sample, x, z);
        sample = RARE_CAVE_LAYER.operate(random, sample, x, z);
        sample = ORE_LAYER.operate(random, sample, x, z);
        return sample;
    }

    static {
        BASE_DECORATOR_LIST.add(CaveDecorators.NONE);
        BASE_DECORATOR_LIST.add(CaveDecorators.WATER);
        BASE_DECORATOR_LIST.add(CaveDecorators.LAVA);
        BASE_DECORATOR_LIST.add(CaveDecorators.VINES);
        BASE_DECORATOR_LIST.add(CaveDecorators.OBSIDIAN);
        BASE_DECORATOR_LIST.add(CaveDecorators.MAGMA);
        BASE_DECORATOR_LIST.add(CaveDecorators.COBBLESTONE);
        BASE_DECORATOR_LIST.add(CaveDecorators.GRAVEL);
        MASTER_DECORATOR_LIST.addAll(BASE_DECORATOR_LIST);
        MASTER_DECORATOR_LIST.add(CaveDecorators.ANDESITE);
        MASTER_DECORATOR_LIST.add(CaveDecorators.DIORITE);
        MASTER_DECORATOR_LIST.add(CaveDecorators.GRANITE);
        MASTER_DECORATOR_LIST.add(CaveDecorators.COBWEB);
        MASTER_DECORATOR_LIST.add(CaveDecorators.FULL_OBSIDIAN);
        MASTER_DECORATOR_LIST.add(CaveDecorators.MUSHROOM);
        MASTER_DECORATOR_LIST.add(CaveDecorators.COAL);
        MASTER_DECORATOR_LIST.add(CaveDecorators.IRON);
        MASTER_DECORATOR_LIST.add(CaveDecorators.GOLD);
        MASTER_DECORATOR_LIST.add(CaveDecorators.REDSTONE);
        MASTER_DECORATOR_LIST.add(CaveDecorators.LAPIS);
        MASTER_DECORATOR_LIST.add(CaveDecorators.DIAMOND);
        INIT_LAYER = new CaveInitLayer();
        STONE_LAYER = new RandomStoneLayer();
        RARE_CAVE_LAYER = new RareCaveLayer();
        ORE_LAYER = new OreLayer();
    }
}

