/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.chanceglobe;

import bl4ckscor3.mod.chanceglobe.Configuration;
import bl4ckscor3.mod.chanceglobe.blocks.BlockChanceGlobe;
import bl4ckscor3.mod.chanceglobe.network.IProxy;
import bl4ckscor3.mod.chanceglobe.tileentity.TileEntityChanceGlobe;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="chanceglobe", name="Chance Globe", version="v1.1", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class ChanceGlobe {
    public static final String MODID = "chanceglobe";
    public static final String NAME = "Chance Globe";
    public static final String VERSION = "v1.1";
    public static final String MC_VERSION = "1.12.2";
    @SidedProxy(clientSide="bl4ckscor3.mod.chanceglobe.network.ClientProxy", serverSide="bl4ckscor3.mod.chanceglobe.network.ServerProxy")
    public static IProxy proxy;
    @GameRegistry.ObjectHolder(value="chanceglobe:chance_globe")
    public static final Block CHANCE_GLOBE;
    public static final NonNullList<ItemStack> BLOCKS_AND_ITEMS;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata meta = event.getModMetadata();
        meta.authorList = Arrays.asList("bl4ckscor3");
        meta.autogenerated = false;
        meta.description = "Spawns a random block or item upon placing it down!";
        meta.modId = MODID;
        meta.name = NAME;
        meta.version = VERSION;
        meta.url = "https://minecraft.curseforge.com/projects/chance-globe";
        proxy.registerRenderers();
    }

    @SubscribeEvent
    public static void onRegistryEventRegisterBlock(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)new BlockChanceGlobe());
        GameRegistry.registerTileEntity(TileEntityChanceGlobe.class, (ResourceLocation)new ResourceLocation(MODID, "chance_globe"));
    }

    @SubscribeEvent
    public static void onRegistryEventRegisterItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new ItemBlock(CHANCE_GLOBE).setRegistryName("chance_globe"));
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)CHANCE_GLOBE), (int)0, (ModelResourceLocation)new ModelResourceLocation("chanceglobe:chance_globe", "inventory"));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ChanceGlobe.generateItemStacks();
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
            ChanceGlobe.generateItemStacks();
        }
    }

    private static void generateItemStacks() {
        NonNullList temp = NonNullList.func_191196_a();
        List<String> filteredBlocks = Arrays.asList(Configuration.filteredBlocks);
        List<String> filteredItems = Arrays.asList(Configuration.filteredItems);
        BLOCKS_AND_ITEMS.clear();
        block8: for (Block block : ForgeRegistries.BLOCKS) {
            Item item;
            if (Configuration.enableFilter) {
                switch (Configuration.filterMode) {
                    case 0: {
                        if (!filteredBlocks.contains(block.getRegistryName().toString())) break;
                        continue block8;
                    }
                    case 1: {
                        if (filteredBlocks.contains(block.getRegistryName().toString())) break;
                        continue block8;
                    }
                }
            }
            if ((item = Item.func_150898_a((Block)block)) == Items.field_190931_a) continue;
            if (item.func_77614_k()) {
                NonNullList list = NonNullList.func_191196_a();
                list.add((Object)new ItemStack(item, 1));
                item.func_150895_a(CreativeTabs.field_78027_g, list);
                temp.addAll((Collection)list);
                continue;
            }
            temp.add((Object)new ItemStack(block, 1));
        }
        block9: for (Item item : ForgeRegistries.ITEMS) {
            if (item instanceof ItemBlock) continue;
            if (Configuration.enableFilter) {
                switch (Configuration.filterMode) {
                    case 0: {
                        if (!filteredItems.contains(item.getRegistryName().toString())) break;
                        continue block9;
                    }
                    case 1: {
                        if (filteredItems.contains(item.getRegistryName().toString())) break;
                        continue block9;
                    }
                }
            }
            if (item == Items.field_190931_a) continue;
            if (item.func_77614_k()) {
                NonNullList list = NonNullList.func_191196_a();
                list.add((Object)new ItemStack(item, 1));
                item.func_150895_a(CreativeTabs.field_78027_g, list);
                temp.addAll((Collection)list);
                continue;
            }
            temp.add((Object)new ItemStack(item, 1));
        }
        block10: for (ItemStack stack : temp) {
            for (ItemStack bi : BLOCKS_AND_ITEMS) {
                if (!stack.func_77969_a(bi)) continue;
                continue block10;
            }
            BLOCKS_AND_ITEMS.add((Object)stack);
        }
        Collections.shuffle(BLOCKS_AND_ITEMS);
    }

    static {
        CHANCE_GLOBE = null;
        BLOCKS_AND_ITEMS = NonNullList.func_191196_a();
    }
}

