/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.chanceglobe;

import bl4ckscor3.mod.chanceglobe.Configuration;
import bl4ckscor3.mod.chanceglobe.blocks.BlockChanceGlobe;
import bl4ckscor3.mod.chanceglobe.renderer.TileEntityChanceGlobeRenderer;
import bl4ckscor3.mod.chanceglobe.tileentity.TileEntityChanceGlobe;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="chanceglobe")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChanceGlobe {
    public static final String MODID = "chanceglobe";
    public static final String NAME = "Chance Globe";
    @ObjectHolder(value="chanceglobe:chance_globe")
    public static final Block CHANCE_GLOBE = null;
    public static TileEntityType<TileEntityChanceGlobe> teTypeGlobe;
    public static final NonNullList<ItemStack> BLOCKS_AND_ITEMS;

    public ChanceGlobe() {
        MinecraftForge.EVENT_BUS.addListener(this::onModelRegistry);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Configuration.CONFIG_SPEC);
    }

    @SubscribeEvent
    public static void onRegistryEventRegisterBlock(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)new BlockChanceGlobe());
    }

    @SubscribeEvent
    public static void onRegistryEventRegisterTileEntityType(RegistryEvent.Register<TileEntityType<?>> event) {
        teTypeGlobe = TileEntityType.func_200966_a((String)CHANCE_GLOBE.getRegistryName().toString(), (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityChanceGlobe::new));
    }

    @SubscribeEvent
    public static void onRegistryEventRegisterItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new ItemBlock(CHANCE_GLOBE, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(CHANCE_GLOBE.getRegistryName()));
    }

    public void onModelRegistry(ModelRegistryEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityChanceGlobe.class, (TileEntityRenderer)new TileEntityChanceGlobeRenderer());
    }

    @SubscribeEvent
    public static void onInterModProcess(InterModProcessEvent event) {
        ChanceGlobe.generateItemStacks();
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ChanceGlobe.generateItemStacks();
        }
    }

    private static void generateItemStacks() {
        NonNullList temp = NonNullList.func_191196_a();
        BLOCKS_AND_ITEMS.clear();
        block8: for (Block block : ForgeRegistries.BLOCKS) {
            if (((Boolean)Configuration.CONFIG.enableFilter.get()).booleanValue()) {
                switch ((Integer)Configuration.CONFIG.filterMode.get()) {
                    case 0: {
                        if (!((List)Configuration.CONFIG.filteredMods.get()).contains(block.getRegistryName().func_110624_b()) && !((List)Configuration.CONFIG.filteredBlocks.get()).contains(block.getRegistryName().toString())) break;
                        continue block8;
                    }
                    case 1: {
                        if (((List)Configuration.CONFIG.filteredMods.get()).contains(block.getRegistryName().func_110624_b()) || ((List)Configuration.CONFIG.filteredBlocks.get()).contains(block.getRegistryName().toString())) break;
                        continue block8;
                    }
                }
            }
            temp.add((Object)new ItemStack((IItemProvider)block, 1));
        }
        block9: for (Item item : ForgeRegistries.ITEMS) {
            if (item instanceof ItemBlock) continue;
            if (((Boolean)Configuration.CONFIG.enableFilter.get()).booleanValue()) {
                switch ((Integer)Configuration.CONFIG.filterMode.get()) {
                    case 0: {
                        if (!((List)Configuration.CONFIG.filteredMods.get()).contains(item.getRegistryName().func_110624_b()) && !((List)Configuration.CONFIG.filteredItems.get()).contains(item.getRegistryName().toString())) break;
                        continue block9;
                    }
                    case 1: {
                        if (((List)Configuration.CONFIG.filteredMods.get()).contains(item.getRegistryName().func_110624_b()) || ((List)Configuration.CONFIG.filteredItems.get()).contains(item.getRegistryName().toString())) break;
                        continue block9;
                    }
                }
            }
            temp.add((Object)new ItemStack((IItemProvider)item, 1));
        }
        block10: for (ItemStack stack : temp) {
            for (ItemStack bi : BLOCKS_AND_ITEMS) {
                if (!stack.func_77969_a(bi)) continue;
                continue block10;
            }
            BLOCKS_AND_ITEMS.add((Object)stack);
        }
        Collections.shuffle(BLOCKS_AND_ITEMS);
    }

    static {
        BLOCKS_AND_ITEMS = NonNullList.func_191196_a();
    }
}

