/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.chanceglobe;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Configuration {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final Configuration CONFIG;
    public final ForgeConfigSpec.BooleanValue enableFilter;
    public final ForgeConfigSpec.IntValue filterMode;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> filteredBlocks;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> filteredItems;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> filteredMods;
    public final ForgeConfigSpec.DoubleValue durationMultiplier;

    Configuration(ForgeConfigSpec.Builder builder) {
        this.enableFilter = builder.comment("Enable black- or whitelisting items and blocks").define("enable_filter", true);
        this.filterMode = builder.comment("Set to 0 for blacklist (all blocks/items EXCEPT the ones listed will be used for randomization), 1 for whitelist (only the blocks/items listed will be used for randomization). Make sure to set enable_filter to true if you want to use the lists.").defineInRange("filter_mode", 0, 0, 1);
        this.filteredBlocks = builder.comment("These blocks will be filtered if enable_filter is set to true. Whether to use white- or blacklisting is defined by the filter_mode option. Use the block's registry name. E.g. to filter grass, use minecraft:grass").defineList("filtered_blocks", (List)Lists.newArrayList((Object[])new String[]{"minecraft:barrier", "minecraft:bedrock", "minecraft:dragon_egg", "minecraft:chain_command_block", "minecraft:command_block", "minecraft:spawner", "minecraft:repeating_command_block", "minecraft:structure_block", "minecraft:structure_void"}), e -> e instanceof String);
        this.filteredItems = builder.comment("These items will be filtered if enable_filter is set to true. Whether to use white- or blacklisting is defined by the filter_mode option. Use the item's registry name. E.g. to filter sticks, use minecraft:stick").defineList("filtered_items", (List)Lists.newArrayList((Object[])new String[]{"minecraft:command_block_minecart", "minecraft:knowledge_book"}), e -> e instanceof String);
        this.filteredMods = builder.comment("These mods will be filtered according to filter_mode if enable_filter is set to true. This list contains modids.").defineList("filtered_mods", (List)Lists.newArrayList(), e -> e instanceof String);
        this.durationMultiplier = builder.comment("The default duration until a block gets placed/an item drops is 10 seconds. With this multiplier, you can change the timing. E.g. setting the value to 2 will make the duration twice as long (20 seconds).").defineInRange("duration_multiplier", 1.0, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Configuration::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (Configuration)specPair.getLeft();
    }
}

