/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import svenhjol.meson.Meson;
import svenhjol.meson.iface.IMesonEnchantment;

public class EnchantmentHelper
extends net.minecraft.enchantment.EnchantmentHelper {
    private static List<Enchantment> availableCurses = new ArrayList<Enchantment>();

    public static void addAvailableCurses(Enchantment ... curses) {
        availableCurses.addAll(Arrays.asList(curses));
    }

    public static List<Enchantment> getItemCurses(ItemStack item) {
        NBTTagList tags = item.func_77986_q();
        ArrayList<Enchantment> curses = new ArrayList<Enchantment>();
        if (!tags.func_82582_d()) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)item);
            for (Map.Entry entry : enchants.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                if (enchantment == null || !enchantment.func_190936_d() && !(enchantment instanceof IMesonEnchantment.ICurse)) continue;
                curses.add(enchantment);
            }
        }
        return curses;
    }

    public static boolean hasEnchantment(Enchantment enchantment, ItemStack item) {
        if (item.func_77973_b() instanceof ItemEnchantedBook) {
            NBTTagList enchantments = ItemEnchantedBook.func_92110_g((ItemStack)item);
            for (int i = 0; i < enchantments.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = enchantments.func_150305_b(i);
                Enchantment e = Enchantment.func_185262_c((int)nbttagcompound.func_74765_d("id"));
                if (e != enchantment) continue;
                return true;
            }
        } else {
            return EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)item) > 0;
        }
        return false;
    }

    public static boolean isItemCursed(ItemStack item) {
        return EnchantmentHelper.getItemCurses(item).size() > 0;
    }

    public static void applyRandomCurse(EntityPlayer player) {
        ArrayList<Enchantment> curses = new ArrayList<Enchantment>();
        curses.add(Enchantments.field_190940_C);
        curses.add(Enchantments.field_190941_k);
        curses.addAll(availableCurses);
        Enchantment curse = (Enchantment)curses.get(new Random().nextInt(curses.size()));
        ArrayList<ItemStack> curseableItems = new ArrayList<ItemStack>();
        ItemStack itemToCurse = null;
        NonNullList armorInventory = player.field_71071_by.field_70460_b;
        NonNullList mainInventory = player.field_71071_by.field_70462_a;
        NonNullList useInventory = null;
        if (curse != null && curse.field_77351_y != null) {
            switch (curse.field_77351_y) {
                case ARMOR: 
                case WEARABLE: {
                    useInventory = armorInventory;
                    break;
                }
                case WEAPON: 
                case DIGGER: {
                    useInventory = mainInventory;
                    break;
                }
                default: {
                    if (new Random().nextInt(2) == 0) {
                        useInventory = mainInventory;
                        break;
                    }
                    boolean hasArmor = false;
                    for (ItemStack stack : armorInventory) {
                        if (stack.func_190926_b()) continue;
                        hasArmor = true;
                        break;
                    }
                    NonNullList nonNullList = useInventory = hasArmor ? armorInventory : mainInventory;
                }
            }
        }
        if (useInventory != null) {
            for (ItemStack item : useInventory) {
                if (item.func_190926_b() || EnchantmentHelper.isItemCursed(item) || !(item.func_77973_b() instanceof ItemEnchantedBook) && !item.func_77948_v() && !item.func_77956_u() || item.func_77973_b() instanceof ItemEnchantedBook && EnchantmentHelper.func_82781_a((ItemStack)item).size() > 2 || !curse.canApplyAtEnchantingTable(item)) continue;
                curseableItems.add(item);
            }
        }
        if (!curseableItems.isEmpty()) {
            itemToCurse = (ItemStack)curseableItems.get(new Random().nextInt(curseableItems.size()));
        }
        if (itemToCurse != null) {
            Map existing = EnchantmentHelper.func_82781_a(itemToCurse);
            existing.put(curse, 1);
            EnchantmentHelper.func_82782_a((Map)existing, (ItemStack)itemToCurse);
        } else {
            Meson.debug("No item to curse!");
        }
    }

    public static void removeRandomCurse(ItemStack stack) {
        List<Enchantment> curses = EnchantmentHelper.getItemCurses(stack);
        if (curses.size() > 0) {
            Enchantment curseToRemove = curses.get(new Random().nextInt(curses.size()));
            EnchantmentHelper.removeEnchantment(curseToRemove, stack);
        }
    }

    public static void removeEnchantment(Enchantment enchantment, ItemStack stack) {
        if (EnchantmentHelper.hasEnchantment(enchantment, stack)) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchants.remove(enchantment);
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
        }
    }
}

