/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.brewing.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import svenhjol.charm.brewing.module.FlavoredCake;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.PotionHelper;
import svenhjol.meson.iface.IMesonBlock;

public class FlavoredCakeBlock
extends CakeBlock
implements IMesonBlock {
    public String baseName;
    public String modName;
    public String potionName;
    private MesonModule module;

    public FlavoredCakeBlock(MesonModule module, String modName, String potionName) {
        super(Block.Properties.func_200945_a((Material)Material.field_151568_F).func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g));
        this.module = module;
        this.modName = modName;
        this.potionName = potionName;
        this.baseName = "cake_" + potionName;
        this.register(module, this.baseName);
    }

    @Override
    public ItemGroup getItemGroup() {
        return ItemGroup.field_78039_h;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.isEnabled() && group == ItemGroup.field_78027_g) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.module.enabled;
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult block) {
        if (!world.field_72995_K && super.func_220051_a(state, world, pos, player, hand, block)) {
            this.onEaten(player);
            return true;
        }
        return false;
    }

    public void onEaten(PlayerEntity player) {
        Potion potion = this.getPotion();
        ItemStack potionItem = PotionHelper.getPotionItemStack(potion, 1);
        List effects = PotionUtils.func_185189_a((ItemStack)potionItem);
        int duration = 0;
        for (EffectInstance effect : effects) {
            duration = Math.max(duration, effect.func_76459_b());
        }
        if (duration == 0) {
            duration = 10;
        }
        for (EffectInstance effectInstance : PotionUtils.func_185189_a((ItemStack)potionItem)) {
            EffectInstance effect = new EffectInstance(effectInstance.func_188419_a(), (int)((double)duration * FlavoredCake.multiplier));
            player.func_195064_c(effect);
        }
    }

    @Nullable
    public Potion getPotion() {
        String name;
        String[] names;
        Potion potion = null;
        String longName = this.modName + ":long_" + this.potionName;
        String shortName = this.modName + ":short_" + this.potionName;
        String[] stringArray = names = new String[]{longName, shortName, this.potionName};
        int n = stringArray.length;
        for (int i = 0; i < n && (potion = Potion.func_185168_a((String)(name = stringArray[i]))).func_185170_a().isEmpty(); ++i) {
        }
        if (potion.func_185170_a().isEmpty()) {
            Meson.LOG.debug("No potion registered for " + this.potionName);
            return null;
        }
        return potion;
    }
}

