/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.decoration.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import svenhjol.charm.decoration.tileentity.BookshelfChestTileEntity;
import svenhjol.meson.MesonModule;
import svenhjol.meson.block.MesonBlock;
import svenhjol.meson.enums.WoodType;

public class BookshelfChestBlock
extends MesonBlock {
    public static final IntegerProperty SLOTS = IntegerProperty.func_177719_a((String)"slots", (int)0, (int)9);
    protected WoodType wood;

    public BookshelfChestBlock(MesonModule module, WoodType wood) {
        super(module, "bookshelf_chest_" + wood.func_176610_l(), Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(1.5f));
        this.wood = wood;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)SLOTS, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public ItemGroup getItemGroup() {
        return ItemGroup.field_78031_c;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (world.field_72995_K || player.func_175149_v()) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof BookshelfChestTileEntity) {
            BookshelfChestTileEntity bookshelfChest = (BookshelfChestTileEntity)tile;
            bookshelfChest.func_184281_d(player);
            player.func_213829_a((INamedContainerProvider)bookshelfChest);
            return true;
        }
        return false;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile;
        if (state.func_177230_c() != newState.func_177230_c() && (tile = world.func_175625_s(pos)) instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tile));
            world.func_175666_e(pos, (Block)this);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)SLOTS);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BookshelfChestTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 50;
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        return 1.0f;
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{SLOTS});
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        TileEntity tile;
        if (stack.func_82837_s() && (tile = world.func_175625_s(pos)) instanceof BookshelfChestTileEntity) {
            ((BookshelfChestTileEntity)tile).func_213903_a(stack.func_200301_q());
        }
    }
}

