/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.decoration.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;
import svenhjol.charm.decoration.block.BookshelfChestBlock;
import svenhjol.charm.decoration.container.BookshelfChestContainer;
import svenhjol.charm.decoration.inventory.BookshelfChestScreen;
import svenhjol.charm.decoration.tileentity.BookshelfChestTileEntity;
import svenhjol.meson.MesonModule;
import svenhjol.meson.enums.WoodType;
import svenhjol.meson.handler.RegistryHandler;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.IMesonBlock;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Decoration", description="A bookshelf with 9 slots that can store books.\nProvides the same enchanting power as a normal bookshelf as long as there is at least 1 book on the shelf.")
public class BookshelfChests
extends MesonModule {
    public static List<Class<? extends Item>> validItems = new ArrayList<Class<? extends Item>>();
    public static Map<WoodType, IMesonBlock> blocks = new HashMap<WoodType, IMesonBlock>();
    @Config(name="Valid books", description="List of item IDs that may be placed in a bookshelf chest.")
    public static List<String> configValidItems = Arrays.asList("minecraft:book", "minecraft:enchanted_book", "minecraft:written_book", "minecraft:writable_book", "minecraft:knowledge_book", "minecraft:paper", "minecraft:map", "minecraft:filled_map", "quark:ancient_tome");
    @ObjectHolder(value="charm:bookshelf_chest")
    public static ContainerType<BookshelfChestContainer> container;
    @ObjectHolder(value="charm:bookshelf_chest")
    public static TileEntityType<BookshelfChestTileEntity> tile;

    @Override
    public void init() {
        for (WoodType wood : WoodType.values()) {
            blocks.put(wood, new BookshelfChestBlock(this, wood));
        }
        ResourceLocation res = new ResourceLocation("charm", "bookshelf_chest");
        container = new ContainerType(BookshelfChestContainer::instance);
        tile = TileEntityType.Builder.func_223042_a(BookshelfChestTileEntity::new, (Block[])new Block[0]).func_206865_a(null);
        RegistryHandler.registerTile(tile, res);
        RegistryHandler.registerContainer(container, res);
    }

    public static boolean canInsertItem(ItemStack stack) {
        return validItems.contains(stack.func_77973_b().getClass());
    }

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event) {
        configValidItems.forEach(string -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string));
            if (item != null) {
                validItems.add(item.getClass());
            }
        });
    }

    @Override
    public void onClientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(container, BookshelfChestScreen::new);
    }
}

