/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enchanting.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.TieredItem;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.enchanting.enchantment.HomingEnchantment;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.EnchantmentsHelper;
import svenhjol.meson.helper.PlayerHelper;
import svenhjol.meson.helper.WorldHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Enchanting", hasSubscriptions=true, description="A tool with the Homing enchantment is attracted to ore/wood/stone of the same type that make up the head of the tool.\nRight click underground and if you hear a sound, you can follow it to the source.")
public class Homing
extends MesonModule {
    public static HomingEnchantment enchantment;
    public static HashMap<IItemTier, List<Block>> matches;
    @Config(name="Detection range", description="Range (in blocks) that the enchanted tool will detect ore/wood/stone.")
    public static int range;
    @Config(name="Damage multiplier", description="Percentage (where 1.0 is 100%) of damage given to the tool every time it detects a block.")
    public static double damageMultiplier;

    @Override
    public void init() {
        enchantment = new HomingEnchantment(this);
        Homing.addHomingBlock(ItemTier.WOOD, Blocks.field_196670_r, Blocks.field_196666_p, Blocks.field_196672_s, Blocks.field_196668_q, Blocks.field_196662_n, Blocks.field_196664_o);
        Homing.addHomingBlock(ItemTier.STONE, Blocks.field_150347_e);
        Homing.addHomingBlock(ItemTier.IRON, Blocks.field_150366_p);
        Homing.addHomingBlock(ItemTier.GOLD, Blocks.field_150352_o);
        Homing.addHomingBlock(ItemTier.DIAMOND, Blocks.field_150482_ag);
    }

    public static void addHomingBlock(ItemTier tier, Block ... blocks) {
        if (!matches.containsKey(tier)) {
            matches.put((IItemTier)tier, new ArrayList());
        }
        matches.get(tier).addAll(Arrays.asList(blocks));
    }

    @SubscribeEvent
    public void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getPlayer().func_184586_b(event.getHand());
        if (held.func_77973_b() instanceof TieredItem && EnchantmentsHelper.hasEnchantment(enchantment, held)) {
            World world = event.getWorld();
            PlayerEntity player = event.getPlayer();
            Hand hand = event.getHand();
            BlockPos pos = event.getPos();
            TieredItem item = (TieredItem)held.func_77973_b();
            List<Block> matchedBlocks = matches.get(item.func_200891_e());
            if (matchedBlocks.isEmpty()) {
                return;
            }
            double distance = 128.0;
            Stream inRange = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range));
            List positions = inRange.map(BlockPos::func_185334_h).collect(Collectors.toList());
            BlockPos foundPos = null;
            for (BlockPos blockPos : positions) {
                double d;
                if (!matchedBlocks.contains(world.func_180495_p(blockPos).func_177230_c()) || !((d = WorldHelper.getDistanceSq(pos, blockPos)) < distance)) continue;
                distance = d;
                foundPos = blockPos;
            }
            if (foundPos != null) {
                player.func_200602_a(EntityAnchorArgument.Type.EYES, new Vec3d(foundPos).func_72441_c(0.5, 0.5, 0.5));
                if (!world.field_72995_K) {
                    double damage = (double)held.func_77958_k() * damageMultiplier;
                    PlayerHelper.damageHeldItem(player, hand, held, (int)Math.ceil(damage));
                }
                if (world.field_72995_K) {
                    double vol = 1.0 - Math.min(distance, 100.0) / 100.0;
                    double pitch = Math.max(0.5, 1.0 - Math.min(distance, 100.0) / 100.0);
                    player.func_184609_a(event.getHand());
                    world.func_184133_a(player, player.func_180425_c(), CharmSounds.HOMING, SoundCategory.BLOCKS, (float)vol, (float)pitch);
                }
            }
        }
    }

    static {
        matches = new HashMap();
        range = 8;
        damageMultiplier = 0.015;
    }
}

