/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tools.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import svenhjol.meson.MesonItem;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.ItemNBTHelper;

public class BoundCompassItem
extends MesonItem {
    private static final String POS = "pos";
    private static final String DIM = "dim";
    private static final String COLOR = "color";
    private static final String ROTA = "rota";
    private static final String ROTATION = "rotation";
    private static final String LASTUPDATE = "lastUpdateTick";

    public BoundCompassItem(MesonModule module) {
        super(module, "bound_compass", new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable World world, @Nullable LivingEntity entityIn) {
                double angle;
                boolean validDimension;
                LivingEntity entity;
                if (entityIn == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean hasEntity = entityIn != null;
                Object object = entity = hasEntity ? entityIn : stack.func_82836_z();
                if (world == null) {
                    world = ((Entity)Objects.requireNonNull(entity)).field_70170_p;
                }
                BlockPos pos = BoundCompassItem.getPos(stack);
                int dim = BoundCompassItem.getDim(stack);
                if (pos != null) {
                    validDimension = world.func_201675_m().func_186058_p().func_186068_a() == dim;
                } else {
                    pos = world.func_175694_M();
                    boolean bl = validDimension = world.func_201675_m().func_186058_p().func_186068_a() == 0;
                }
                if (validDimension) {
                    double yaw = hasEntity ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)Objects.requireNonNull(entity));
                    yaw = MathHelper.func_191273_b((double)(yaw / 360.0), (double)1.0);
                    double relAngle = this.getPosToAngle((Entity)entity, pos) / (Math.PI * 2);
                    angle = 0.5 - (yaw - 0.25 - relAngle);
                } else {
                    angle = Math.random();
                }
                if (hasEntity) {
                    angle = this.wobble(world, stack, angle);
                }
                return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(World worldIn, ItemStack stack, double angle) {
                if (!stack.func_77942_o()) {
                    return 0.0;
                }
                double rotation = ItemNBTHelper.getDouble(stack, BoundCompassItem.ROTATION, 0.0);
                double rota = ItemNBTHelper.getDouble(stack, BoundCompassItem.ROTA, 0.0);
                long lastUpdateTick = ItemNBTHelper.getLong(stack, BoundCompassItem.LASTUPDATE, 0L);
                if (worldIn.func_82737_E() != lastUpdateTick) {
                    lastUpdateTick = worldIn.func_82737_E();
                    double d0 = angle - rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    rota += d0 * 0.1;
                    rotation = MathHelper.func_191273_b((double)(rotation + (rota *= 0.8)), (double)1.0);
                }
                ItemNBTHelper.setLong(stack, BoundCompassItem.LASTUPDATE, lastUpdateTick);
                ItemNBTHelper.setDouble(stack, BoundCompassItem.ROTATION, rotation);
                ItemNBTHelper.setDouble(stack, BoundCompassItem.ROTA, rota);
                return rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrameEntity frame) {
                return MathHelper.func_188209_b((int)(180 + Objects.requireNonNull(frame.func_174811_aO()).func_176736_b() * 90));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getPosToAngle(Entity entity, BlockPos pos) {
                BlockPos entityPos = entity.func_180425_c();
                return Math.atan2(pos.func_177952_p() - entityPos.func_177952_p(), pos.func_177958_n() - entityPos.func_177958_n());
            }
        });
    }

    public static int getColor(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, COLOR, 0);
    }

    public static int getDim(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, DIM, 0);
    }

    @Nullable
    public static BlockPos getPos(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        long pos = ItemNBTHelper.getLong(stack, POS, 0L);
        return BlockPos.func_218283_e((long)pos);
    }

    public static void setColor(ItemStack stack, int color) {
        ItemNBTHelper.setInt(stack, COLOR, color);
    }

    public static void setDim(ItemStack stack, int dim) {
        ItemNBTHelper.setInt(stack, DIM, dim);
    }

    public static void setPos(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setLong(stack, POS, pos.func_218275_a());
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> textComponents, ITooltipFlag flag) {
        BlockPos pos = BoundCompassItem.getPos(stack);
        if (pos != null) {
            String x = String.valueOf(pos.func_177958_n());
            String z = String.valueOf(pos.func_177952_p());
            int dim = BoundCompassItem.getDim(stack);
            textComponents.add((ITextComponent)new TranslationTextComponent("gui.charm.bound_compass_location", new Object[]{x, z, dim}));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return BoundCompassItem.getPos(stack) != null;
    }
}

