/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tools.module;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.tools.item.BatBucketItem;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.ClientHelper;
import svenhjol.meson.helper.ItemNBTHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Tools", hasSubscriptions=true, description="Right-click a bat with a bucket to capture it.\nRight-click your Bat in a Bucket to release the bat and help locate entities around you.")
public class BatInABucket
extends MesonModule {
    public static BatBucketItem item;
    @Config(name="Glowing time", description="Number of seconds that entities will receive the glowing effect.")
    public static int time;
    @Config(name="Viewing range", description="Range (in blocks) in which entities will glow.")
    public static int range;
    public static int clientTicks;
    public static double clientRange;
    public static List<Entity> clientEntities;

    @Override
    public void init() {
        item = new BatBucketItem(this);
    }

    @SubscribeEvent
    public void onInteractWithBat(PlayerInteractEvent.EntityInteract event) {
        if (!event.isCanceled() && !event.getWorld().field_72995_K && event.getTarget() instanceof BatEntity && ((BatEntity)event.getTarget()).func_110143_aJ() > 0.0f) {
            PlayerEntity player = event.getPlayer();
            Hand hand = event.getHand();
            BatEntity bat = (BatEntity)event.getTarget();
            ItemStack held = player.func_184586_b(hand);
            if (held.func_190926_b() || held.func_77973_b() != Items.field_151133_ar) {
                return;
            }
            ItemStack batBucket = new ItemStack((IItemProvider)item);
            CompoundNBT tag = bat.serializeNBT();
            ItemNBTHelper.setCompound(batBucket, "stored_bat", tag);
            player.func_184611_a(hand, batBucket);
            player.func_184609_a(hand);
            event.getTarget().func_70106_y();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (clientTicks > 0 && clientRange > 0.0 && event.phase == TickEvent.Phase.START && ClientHelper.getClientPlayer() != null) {
            PlayerEntity player = ClientHelper.getClientPlayer();
            if (clientTicks % 10 == 0 || clientEntities.isEmpty()) {
                this.setGlowing(false);
                this.setNearbyEntities(player);
                this.setGlowing(true);
            }
            if (--clientTicks <= 0) {
                this.setGlowing(false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setNearbyEntities(PlayerEntity player) {
        clientEntities.clear();
        AxisAlignedBB area = player.func_174813_aQ().func_72314_b(clientRange, clientRange / 2.0, clientRange);
        Predicate<Entity> selector = entity -> true;
        clientEntities = player.field_70170_p.func_175647_a(Entity.class, area, selector);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setGlowing(boolean glowing) {
        for (Entity entity : clientEntities) {
            entity.func_184195_f(glowing);
        }
    }

    static {
        time = 10;
        range = 24;
        clientEntities = new ArrayList<Entity>();
    }
}

