/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tools.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.tools.item.BoundCompassItem;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.PlayerHelper;
import svenhjol.meson.helper.StringHelper;
import svenhjol.meson.helper.WorldHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Tools", hasSubscriptions=true, description="Right-click with a compass on a banner or beacon whilst sneaking to bind the compass to the target's location.")
public class CompassBinding
extends MesonModule {
    public static BoundCompassItem item;
    public static List<Item> bindableItems;
    @Config(name="Bind to Banners", description="If true, compasses can bind to banners.")
    public static boolean useBanners;
    @Config(name="Bind to Beacons", description="If true, compasses can bind to beacons.")
    public static boolean useBeacons;

    @Override
    public void init() {
        item = new BoundCompassItem(this);
        bindableItems.add(Items.field_151111_aL);
        bindableItems.add(item);
    }

    @SubscribeEvent
    public void onCompassUse(PlayerInteractEvent.RightClickBlock event) {
        if (event.getPlayer() != null && PlayerHelper.isCrouching(event.getPlayer()) && bindableItems.contains(event.getPlayer().func_184586_b(event.getHand()).func_77973_b())) {
            PlayerEntity player = event.getPlayer();
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            BlockState state = world.func_180495_p(pos);
            Hand hand = event.getHand();
            boolean validCompass = false;
            DyeColor color = DyeColor.WHITE;
            String name = "";
            ItemStack compass = new ItemStack((IItemProvider)item);
            TileEntity tile = world.func_175625_s(pos);
            if (useBanners && tile instanceof BannerTileEntity) {
                BannerTileEntity banner = (BannerTileEntity)tile;
                color = banner.func_195533_l(() -> state);
                if (banner.func_145818_k_()) {
                    name = banner.func_145748_c_().func_150261_e();
                }
                validCompass = true;
            }
            if (useBeacons && tile instanceof BeaconTileEntity) {
                BeaconTileEntity beacon = (BeaconTileEntity)tile;
                for (int i = 1; i < 255; ++i) {
                    BlockState stateUp = world.func_180495_p(pos.func_177967_a(Direction.UP, i));
                    if (!(stateUp.func_177230_c() instanceof StainedGlassBlock)) continue;
                    color = ((StainedGlassBlock)stateUp.func_177230_c()).func_196457_d();
                    break;
                }
                name = Objects.requireNonNull(beacon.func_145748_c_()).getString();
                validCompass = true;
            }
            if (!validCompass) {
                return;
            }
            BlockPos compassPos = new BlockPos((Vec3i)pos);
            name = name.length() > 0 ? name : new TranslationTextComponent("item.charm.bound_compass", new Object[0]).func_150261_e();
            StringTextComponent strName = new StringTextComponent(name);
            strName.func_150255_a(new Style().func_150238_a(StringHelper.getTextFormattingByDyeDamage(color.func_196059_a())));
            compass.func_200302_a((ITextComponent)strName);
            BoundCompassItem.setPos(compass, compassPos);
            BoundCompassItem.setDim(compass, WorldHelper.getDimensionId(world));
            BoundCompassItem.setColor(compass, color.getColorValue());
            PlayerHelper.setHeldItem(player, hand, compass);
        }
    }

    static {
        bindableItems = new ArrayList<Item>();
        useBanners = true;
        useBeacons = true;
    }
}

