/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.state.IProperty;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.dimension.OverworldDimension;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import svenhjol.charm.tweaks.module.AmbientMusicImprovements;
import svenhjol.meson.Meson;
import svenhjol.meson.helper.SoundHelper;

public class AmbientMusicClient {
    public static List<AmbientMusicCondition> conditions = new ArrayList<AmbientMusicCondition>();
    public static ISound currentMusic;
    public static int timeUntilNextMusic;
    private static final Random random;
    private static final Minecraft mc;
    private int ticksBeforeStop;
    private ISound musicToStop = null;

    public void setupClient(FMLClientSetupEvent event) {
        if (AmbientMusicImprovements.playCreativeMusic) {
            conditions.add(new AmbientMusicCondition(SoundEvents.field_187792_dx, 1200, 3600, mc -> mc.field_71439_g != null && (!mc.field_71439_g.func_184812_l_() || !mc.field_71439_g.func_175149_v()) && mc.field_71439_g.field_70170_p.field_73011_w instanceof OverworldDimension && random.nextFloat() < 0.25f));
        }
    }

    @SubscribeEvent
    public void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().field_72995_K) {
            BlockState state = event.getWorld().func_180495_p(event.getPos());
            if (event.getEntity() instanceof PlayerEntity && event.getItemStack().func_77973_b() instanceof MusicDiscItem && state.func_177230_c() == Blocks.field_150421_aI && !((Boolean)state.func_177229_b((IProperty)JukeboxBlock.field_176432_a)).booleanValue()) {
                SoundHelper.getSoundHandler().func_195478_a(null, SoundCategory.MUSIC);
            }
        }
    }

    @SubscribeEvent
    public void onSoundPlay(SoundEvent.SoundSourceEvent event) {
        ISound triggered = event.getSound();
        if (triggered.func_184365_d() == SoundCategory.MUSIC) {
            SoundHelper.getPlayingSounds().forEach((category, sound) -> {
                if (category == SoundCategory.RECORDS) {
                    this.musicToStop = triggered;
                    Meson.LOG.debug("Triggered background music while record playing");
                }
            });
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.musicToStop != null && ++this.ticksBeforeStop % 10 == 0) {
            SoundHelper.getSoundHandler().func_147683_b(this.musicToStop);
            this.ticksBeforeStop = 0;
            this.musicToStop = null;
        }
    }

    public static boolean handleTick(@Nullable ISound current) {
        if (AmbientMusicClient.mc.field_71441_e == null) {
            return false;
        }
        AmbientMusicCondition ambient = AmbientMusicClient.getAmbientMusicType();
        if (currentMusic != null && !mc.func_147118_V().func_215294_c(currentMusic)) {
            currentMusic = null;
            int max = AmbientMusicImprovements.maxDelayOverride == 0 ? ambient.getMaxDelay() : AmbientMusicImprovements.maxDelayOverride;
            timeUntilNextMusic = Math.min(MathHelper.func_76136_a((Random)random, (int)ambient.getMinDelay(), (int)max), timeUntilNextMusic);
        }
        timeUntilNextMusic = Math.min(timeUntilNextMusic, ambient.getMaxDelay());
        if (currentMusic == null && timeUntilNextMusic-- <= 0) {
            currentMusic = SimpleSound.func_184370_a((SoundEvent)ambient.getSound());
            mc.func_147118_V().func_147682_a(currentMusic);
            timeUntilNextMusic = Integer.MAX_VALUE;
        }
        return true;
    }

    public static boolean handleStop() {
        if (currentMusic != null) {
            mc.func_147118_V().func_147683_b(currentMusic);
            currentMusic = null;
            timeUntilNextMusic = 0;
        }
        return true;
    }

    public static boolean handlePlaying(MusicTicker.MusicType type) {
        return currentMusic != null && type.func_188768_a().func_187503_a().equals((Object)currentMusic.func_147650_b());
    }

    public static void forceStop() {
        mc.func_147118_V().func_147683_b(currentMusic);
        currentMusic = null;
        timeUntilNextMusic = 3600;
    }

    public static AmbientMusicCondition getAmbientMusicType() {
        AmbientMusicCondition condition = null;
        if (conditions != null) {
            for (AmbientMusicCondition c : conditions) {
                if (!c.handle()) continue;
                condition = c;
                break;
            }
        }
        if (condition == null) {
            condition = new AmbientMusicCondition(Minecraft.func_71410_x().func_147109_W());
        }
        return condition;
    }

    static {
        timeUntilNextMusic = 100;
        random = new Random();
        mc = Minecraft.func_71410_x();
    }

    public static class AmbientMusicCondition {
        private SoundEvent sound;
        private int minDelay;
        private int maxDelay;
        private Predicate<Minecraft> condition;
        private static final Minecraft mc = Minecraft.func_71410_x();

        public AmbientMusicCondition(SoundEvent sound, int minDelay, int maxDelay, Predicate<Minecraft> condition) {
            this.sound = sound;
            this.minDelay = minDelay;
            this.maxDelay = maxDelay;
            this.condition = condition;
        }

        public AmbientMusicCondition(MusicTicker.MusicType type) {
            this.sound = type.func_188768_a();
            this.minDelay = type.func_148634_b();
            this.maxDelay = type.func_148633_c();
        }

        public boolean handle() {
            if (this.condition == null) {
                return false;
            }
            return this.condition.test(mc);
        }

        public SoundEvent getSound() {
            return this.sound;
        }

        public int getMaxDelay() {
            return this.maxDelay;
        }

        public int getMinDelay() {
            return this.minDelay;
        }
    }
}

