/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.block;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import svenhjol.charm.world.module.EndPortalRunes;
import svenhjol.meson.MesonModule;
import svenhjol.meson.block.MesonBlock;
import svenhjol.meson.enums.ColorVariant;

public class RunePortalFrameBlock
extends MesonBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<ColorVariant> RUNE = EnumProperty.func_177709_a((String)"rune", ColorVariant.class);
    protected static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final VoxelShape RUNE_SHAPE = Block.func_208617_a((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape BASE_WITH_RUNE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)BASE_SHAPE, (VoxelShape)RUNE_SHAPE);
    private static BlockPattern portalShape;

    public RunePortalFrameBlock(MesonModule module) {
        super(module, "rune_portal_frame", Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151651_C).func_200947_a(SoundType.field_185853_f).func_200948_a(-1.0f, 3600000.0f).func_200951_a(1).func_222380_e());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(RUNE, (Comparable)((Object)ColorVariant.WHITE)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BASE_WITH_RUNE_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, RUNE});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)this, 1);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (placer != null) {
            Direction facing = placer.func_174811_aO().func_176734_d();
            state = (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)facing);
            world.func_180501_a(pos, state, 2);
        }
        if (world instanceof ServerWorld) {
            EndPortalRunes.activate((ServerWorld)world, pos);
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        if (world instanceof ServerWorld) {
            EndPortalRunes.deactivate((ServerWorld)world, pos);
        }
    }

    public static BlockPattern getOrCreatePortalShape() {
        if (portalShape == null) {
            portalShape = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"?vvv?", ">???<", ">???<", ">???<", "?^^^?"}).func_177662_a('?', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('^', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)EndPortalRunes.frame).func_201028_a((IProperty)FACING, (Predicate)Predicates.equalTo((Object)Direction.SOUTH)))).func_177662_a('>', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)EndPortalRunes.frame).func_201028_a((IProperty)FACING, (Predicate)Predicates.equalTo((Object)Direction.WEST)))).func_177662_a('v', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)EndPortalRunes.frame).func_201028_a((IProperty)FACING, (Predicate)Predicates.equalTo((Object)Direction.NORTH)))).func_177662_a('<', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)EndPortalRunes.frame).func_201028_a((IProperty)FACING, (Predicate)Predicates.equalTo((Object)Direction.EAST)))).func_177661_b();
        }
        return portalShape;
    }

    @Override
    public ItemGroup getItemGroup() {
        return ItemGroup.field_78027_g;
    }
}

