/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EndPortalBlock;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ObjectHolder;
import svenhjol.charm.Charm;
import svenhjol.charm.world.block.RunePortalBlock;
import svenhjol.charm.world.block.RunePortalFrameBlock;
import svenhjol.charm.world.client.renderer.RunePortalTileEntityRenderer;
import svenhjol.charm.world.message.ClientRunePortalAction;
import svenhjol.charm.world.storage.RunePortalSavedData;
import svenhjol.charm.world.tileentity.RunePortalTileEntity;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonModule;
import svenhjol.meson.enums.ColorVariant;
import svenhjol.meson.handler.RegistryHandler;
import svenhjol.meson.helper.ClientHelper;
import svenhjol.meson.helper.PlayerHelper;
import svenhjol.meson.helper.WorldHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="World", hasSubscriptions=true, description="Add colored runes in stronghold End Portal frames. Two portals with the same runes will be linked together.")
public class EndPortalRunes
extends MesonModule {
    public static RunePortalBlock portal;
    public static RunePortalFrameBlock frame;
    @ObjectHolder(value="charm:rune_portal")
    public static TileEntityType<RunePortalTileEntity> tile;
    @Config(name="Allow Eye of Ender removal", description="If true, sneak-clicking with an empty hand or colored rune removes an eye of ender from its frame.")
    public static boolean allowEnderEyeRemoval;
    @OnlyIn(value=Dist.CLIENT)
    public static long clientTravelTicks;
    @OnlyIn(value=Dist.CLIENT)
    public static long clientUnlinkedTicks;
    @OnlyIn(value=Dist.CLIENT)
    public static long clientLinkedTicks;

    @Override
    public void init() {
        portal = new RunePortalBlock(this);
        frame = new RunePortalFrameBlock(this);
        ResourceLocation res = new ResourceLocation("charm", "rune_portal");
        tile = TileEntityType.Builder.func_223042_a(RunePortalTileEntity::new, (Block[])new Block[]{portal}).func_206865_a(null);
        RegistryHandler.registerTile(tile, res);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientSetup(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(RunePortalTileEntity.class, (TileEntityRenderer)new RunePortalTileEntityRenderer());
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        boolean isModded;
        if (Charm.quarkCompat == null || !Charm.quarkCompat.hasColorRuneModule()) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        if (world.field_72995_K) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)world;
        boolean isVanilla = state.func_177230_c() == Blocks.field_150378_br;
        boolean bl = isModded = state.func_177230_c() == frame;
        if (isVanilla || isModded) {
            BlockState changed = null;
            ItemStack toDrop = null;
            ItemStack held = player.func_184586_b(hand);
            if (Charm.quarkCompat.isRune(held) && !PlayerHelper.isCrouching(player)) {
                if (isVanilla && ((Boolean)state.func_177229_b((IProperty)EndPortalFrameBlock.field_176507_b)).booleanValue()) {
                    if (allowEnderEyeRemoval) {
                        toDrop = new ItemStack((IItemProvider)Items.field_151061_bv);
                    }
                    changed = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((IProperty)EndPortalFrameBlock.field_176508_a, state.func_177229_b((IProperty)RunePortalFrameBlock.FACING));
                }
                if (isModded) {
                    toDrop = Charm.quarkCompat.getRune((ColorVariant)((Object)state.func_177229_b(RunePortalFrameBlock.RUNE)));
                }
                EndPortalRunes.addRune(serverWorld, pos, held, player);
                EndPortalRunes.activate(serverWorld, pos);
            } else if (PlayerHelper.isCrouching(player)) {
                if (isVanilla && allowEnderEyeRemoval && ((Boolean)state.func_177229_b((IProperty)EndPortalFrameBlock.field_176507_b)).booleanValue()) {
                    toDrop = new ItemStack((IItemProvider)Items.field_151061_bv);
                }
                if (isModded) {
                    toDrop = Charm.quarkCompat.getRune((ColorVariant)((Object)state.func_177229_b(RunePortalFrameBlock.RUNE)));
                }
                if (toDrop != null) {
                    changed = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((IProperty)EndPortalFrameBlock.field_176508_a, state.func_177229_b((IProperty)RunePortalFrameBlock.FACING));
                }
                EndPortalRunes.deactivate(serverWorld, pos);
                if (toDrop != null) {
                    event.setCanceled(true);
                }
            }
            if (changed != null) {
                serverWorld.func_180501_a(pos, changed, 2);
            }
            if (toDrop != null) {
                PlayerHelper.addOrDropStack(player, toDrop);
            }
        }
    }

    public static void addRune(ServerWorld world, BlockPos pos, ItemStack rune, @Nullable PlayerEntity player) {
        Direction facing;
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150378_br) {
            facing = (Direction)state.func_177229_b((IProperty)EndPortalFrameBlock.field_176508_a);
        } else if (state.func_177230_c() == frame) {
            facing = (Direction)state.func_177229_b((IProperty)RunePortalFrameBlock.FACING);
        } else {
            Meson.LOG.debug("Not a frame block: " + state);
            return;
        }
        ColorVariant color = Charm.quarkCompat.getRuneColor(rune);
        if (color == null) {
            Meson.LOG.debug("Failed to add rune");
            return;
        }
        BlockState changed = (BlockState)((BlockState)frame.func_176223_P().func_206870_a((IProperty)RunePortalFrameBlock.FACING, (Comparable)facing)).func_206870_a(RunePortalFrameBlock.RUNE, (Comparable)((Object)color));
        world.func_180501_a(pos, changed, 2);
        if (!world.field_72995_K) {
            world.func_184133_a(null, pos, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (player != null && !player.func_184812_l_()) {
            rune.func_190918_g(1);
        }
    }

    public static void activate(ServerWorld world, BlockPos pos) {
        HashMap orderMap = new HashMap();
        BlockPattern.PatternHelper pattern = RunePortalFrameBlock.getOrCreatePortalShape().func_177681_a((IWorldReader)world, pos);
        if (pattern != null) {
            BlockPos patternStart = pattern.func_181117_a().func_177982_a(-5, 0, -5);
            for (int a = 0; a < 6; ++a) {
                for (int b = 0; b < 6; ++b) {
                    BlockState state = world.func_180495_p(patternStart.func_177982_a(a, 0, b));
                    if (state.func_177230_c() != frame) continue;
                    int face = ((Direction)state.func_177229_b((IProperty)RunePortalFrameBlock.FACING)).func_176745_a();
                    if (!orderMap.containsKey(face)) {
                        orderMap.put(face, new ArrayList());
                    }
                    ((List)orderMap.get(face)).add(((ColorVariant)((Object)state.func_177229_b(RunePortalFrameBlock.RUNE))).ordinal());
                }
            }
            BlockPos thisPortal = pattern.func_181117_a();
            RunePortalSavedData data = RunePortalSavedData.get(world);
            ArrayList<Integer> order = new ArrayList<Integer>();
            for (int i2 : new int[]{2, 4, 3, 5}) {
                List row = (List)orderMap.get(i2);
                Collections.sort(row);
                order.addAll(row);
            }
            int[] colors = order.stream().mapToInt(i -> i).toArray();
            data.portals.put(thisPortal, colors);
            data.func_76185_a();
            EndPortalRunes.removeCachedPortal(world, thisPortal);
            if (EndPortalRunes.findPortal(world, thisPortal) != null) {
                Meson.getInstance("charm").getPacketHandler().sendToAll(new ClientRunePortalAction(0, thisPortal));
            }
            BlockPos start = thisPortal.func_177982_a(-3, 0, -3);
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    BlockPos p = start.func_177982_a(j, 0, k);
                    world.func_180501_a(p, portal.func_176223_P(), 2);
                    portal.setPortal((World)world, p, thisPortal, order);
                }
            }
        }
    }

    public static void deactivate(ServerWorld world, BlockPos pos) {
        BlockPos[] thisPortal = new BlockPos[]{null};
        BlockPattern.PatternHelper pattern = RunePortalFrameBlock.getOrCreatePortalShape().func_177681_a((IWorldReader)world, pos);
        if (pattern == null) {
            BlockPos pos1 = pos.func_177982_a(-3, 0, -3);
            BlockPos pos2 = pos.func_177982_a(3, 0, 3);
            Stream inRange = BlockPos.func_218281_b((BlockPos)pos1, (BlockPos)pos2);
            inRange.forEach(p -> {
                Block block = world.func_180495_p(p).func_177230_c();
                if (block instanceof EndPortalBlock) {
                    if (thisPortal[0] == null) {
                        thisPortal[0] = portal.getPortal((World)world, (BlockPos)p);
                    }
                    world.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
                }
            });
            if (thisPortal[0] != null) {
                RunePortalSavedData data = RunePortalSavedData.get(world);
                data.portals.remove(thisPortal[0]);
                data.func_76185_a();
                EndPortalRunes.removeCachedPortal(world, thisPortal[0]);
                if (!world.field_72995_K) {
                    Meson.getInstance("charm").getPacketHandler().sendToAll(new ClientRunePortalAction(1, thisPortal[0]));
                }
            }
        }
    }

    public static void removeCachedPortal(ServerWorld world, BlockPos portal) {
        RunePortalSavedData data = RunePortalSavedData.get(world);
        BlockPos cachedPortal = data.links.get(portal);
        if (cachedPortal != null) {
            data.links.remove(cachedPortal);
            Meson.LOG.debug("EndPortalRunes: [CACHE] clearing cached link: " + cachedPortal);
        }
        data.links.clear();
        data.func_76185_a();
    }

    public static BlockPos findPortal(ServerWorld world, BlockPos thisPortal) {
        RunePortalSavedData data = RunePortalSavedData.get(world);
        BlockPos foundPortal = null;
        ArrayList<BlockPos> matching = new ArrayList<BlockPos>();
        if (data.portals.containsKey(thisPortal)) {
            BlockPos linkedPortal = data.links.get(thisPortal);
            if (linkedPortal != null) {
                if (data.portals.containsKey(linkedPortal)) {
                    Meson.LOG.debug("EndPortalRunes: [CACHE] found portal: " + linkedPortal);
                    return linkedPortal;
                }
                Meson.LOG.debug("EndPortalRunes: [CACHE] cleaning unlinked portal: " + linkedPortal);
                data.links.remove(thisPortal);
                data.func_76185_a();
            }
            List o1 = Arrays.stream(data.portals.get(thisPortal)).boxed().collect(Collectors.toList());
            for (BlockPos portalPos : data.portals.keySet()) {
                boolean matched;
                if (portalPos.func_218275_a() == thisPortal.func_218275_a()) continue;
                List o2 = Arrays.stream(data.portals.get(portalPos)).boxed().collect(Collectors.toList());
                int w = 0;
                do {
                    Collections.rotate(o2, 1);
                } while (!(matched = o1.equals(o2)) && ++w < 12);
                if (!matched) continue;
                matching.add(portalPos);
            }
        }
        if (matching.isEmpty()) {
            return null;
        }
        double dist = 0.0;
        for (BlockPos matchedPortal : matching) {
            double d = WorldHelper.getDistanceSq(thisPortal, matchedPortal);
            if (dist != 0.0 && !(d < dist)) continue;
            foundPortal = matchedPortal;
            dist = d;
        }
        Meson.LOG.debug("EndPortalRunes: found matching portal, caching it: " + foundPortal);
        data.links.put(thisPortal, foundPortal);
        data.links.put(foundPortal, thisPortal);
        data.func_76185_a();
        return foundPortal;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            RunePortalSavedData.get((ServerWorld)event.getWorld());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void effectPortalLinked(BlockPos pos) {
        ClientWorld world = ClientHelper.getClientWorld();
        PlayerEntity player = ClientHelper.getClientPlayer();
        long time = world.func_82737_E();
        if (clientLinkedTicks == 0L || time - clientLinkedTicks > 20L) {
            BlockPos current = pos.func_177982_a(-3, 0, -3);
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    BlockPos p = current.func_177982_a(j, 0, k);
                    for (int i = 0; i < 12; ++i) {
                        double d0 = world.field_73012_v.nextGaussian() * 0.1;
                        double d1 = world.field_73012_v.nextGaussian() * 0.1;
                        double d2 = world.field_73012_v.nextGaussian() * 0.1;
                        double dx = (float)p.func_177958_n() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        double dy = (float)p.func_177956_o() + 1.1f;
                        double dz = (float)p.func_177952_p() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, dx, dy, dz, d0, d1, d2);
                    }
                }
            }
            world.func_184133_a(player, pos, SoundEvents.field_187814_ei, SoundCategory.PLAYERS, 0.8f, 1.45f);
            clientLinkedTicks = time;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void effectPortalUnlinked(BlockPos pos) {
        ClientWorld world = ClientHelper.getClientWorld();
        PlayerEntity player = ClientHelper.getClientPlayer();
        long time = world.func_82737_E();
        if (clientUnlinkedTicks == 0L || time - clientUnlinkedTicks > 20L) {
            BlockPos current = pos.func_177982_a(-3, 0, -3);
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    BlockPos p = current.func_177982_a(j, 0, k);
                    for (int i = 0; i < 16; ++i) {
                        double d0 = world.field_73012_v.nextGaussian() * 0.02;
                        double d1 = world.field_73012_v.nextGaussian() * 0.02;
                        double d2 = world.field_73012_v.nextGaussian() * 0.02;
                        double dx = (float)p.func_177958_n() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        double dy = (float)p.func_177956_o() + 0.5f;
                        double dz = (float)p.func_177952_p() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, dx, dy, dz, d0, d1, d2);
                    }
                }
            }
            world.func_184133_a(player, pos, SoundEvents.field_187541_bC, SoundCategory.PLAYERS, 0.75f, 0.7f);
            clientUnlinkedTicks = time;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void effectPortalTravelled(BlockPos pos) {
        ClientWorld world = ClientHelper.getClientWorld();
        PlayerEntity player = ClientHelper.getClientPlayer();
        long time = world.func_82737_E();
        if (clientTravelTicks == 0L || time - clientTravelTicks > 20L) {
            BlockPos current = pos.func_177982_a(-3, 0, -3);
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    BlockPos p = current.func_177982_a(j, 0, k);
                    for (int i = 0; i < 6; ++i) {
                        double d0 = world.field_73012_v.nextGaussian() * 0.1;
                        double d1 = world.field_73012_v.nextGaussian() * 0.1;
                        double d2 = world.field_73012_v.nextGaussian() * 0.1;
                        double dx = (float)p.func_177958_n() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        double dy = (float)p.func_177956_o() + 0.8f;
                        double dz = (float)p.func_177952_p() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, dx, dy, dz, d0, d1, d2);
                    }
                }
            }
            world.func_184133_a(player, pos, SoundEvents.field_187812_eh, SoundCategory.PLAYERS, 0.75f, 1.0f);
            clientTravelTicks = time;
        }
    }

    static {
        allowEnderEyeRemoval = true;
    }
}

