/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.module;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.enchanting.module.CurseBreak;
import svenhjol.meson.MesonModule;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="World", hasSubscriptions=true, description="Adds additional trades to village professions. \nLibrarians buy back any enchanted books and sell curse break books, \nbutchers and leatherworkers will trade zombie flesh for meat and leather, \ntoolsmiths will repair anvils for an iron ingot cost.")
public class MoreVillagerTrades
extends MesonModule {
    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades = event.getTrades();
        VillagerProfession profession = event.getType();
        if (profession.getRegistryName() == null) {
            return;
        }
        switch (profession.getRegistryName().func_110623_a()) {
            case "librarian": {
                ((List)trades.get(3)).add(new EmeraldsForAnyEnchantedBookTrade());
                ((List)trades.get(5)).add(new CurseBreakForEmeraldsTrade());
                break;
            }
            case "butcher": {
                ((List)trades.get(3)).add(new ItemForZombieFleshTrade(Items.field_151147_al, 3, 6));
                break;
            }
            case "leatherworker": {
                ((List)trades.get(3)).add(new ItemForZombieFleshTrade(Items.field_151116_aA, 1, 3));
                break;
            }
            case "armorer": 
            case "weaponsmith": 
            case "toolsmith": {
                ((List)trades.get(2)).add(new RepairedAnvilForDamagedAnvilTrade());
                break;
            }
        }
    }

    static class CurseBreakForEmeraldsTrade
    implements VillagerTrades.ITrade {
        CurseBreakForEmeraldsTrade() {
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity merchant, Random rand) {
            int emeraldCount = 2 * rand.nextInt(15) + 5;
            ItemStack in1 = new ItemStack((IItemProvider)Items.field_151166_bC, emeraldCount);
            ItemStack out = new ItemStack((IItemProvider)Items.field_151134_bR);
            EnchantmentHelper.func_82782_a((Map)new HashMap<Enchantment, Integer>(){
                {
                    this.put(CurseBreak.enchantment, 1);
                }
            }, (ItemStack)out);
            return new MerchantOffer(in1, out, 1, 5, 0.2f);
        }
    }

    static class EmeraldsForAnyEnchantedBookTrade
    implements VillagerTrades.ITrade {
        EmeraldsForAnyEnchantedBookTrade() {
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity merchant, Random rand) {
            int emeraldCount = rand.nextInt(1) + 2;
            ItemStack in1 = new ItemStack((IItemProvider)Items.field_151134_bR);
            ItemStack out = new ItemStack((IItemProvider)Items.field_151166_bC, emeraldCount);
            return new MerchantOffer(in1, out, 10, 5, 0.2f);
        }
    }

    static class ItemForZombieFleshTrade
    implements VillagerTrades.ITrade {
        private final Item trade;
        private final int min;
        private final int max;

        public ItemForZombieFleshTrade(Item trade, int min, int max) {
            this.trade = trade;
            this.min = min;
            this.max = max;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity merchant, Random rand) {
            int count = rand.nextInt(this.max - this.min) + this.min;
            ItemStack in1 = new ItemStack((IItemProvider)Items.field_151078_bh, count * 4);
            ItemStack out = new ItemStack((IItemProvider)this.trade, count);
            return new MerchantOffer(in1, out, 10, 5, 0.2f);
        }
    }

    static class RepairedAnvilForDamagedAnvilTrade
    implements VillagerTrades.ITrade {
        RepairedAnvilForDamagedAnvilTrade() {
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity merchant, Random rand) {
            ItemStack in1 = new ItemStack((IItemProvider)(rand.nextFloat() > 0.5f ? Items.field_221848_eh : Items.field_221846_eg));
            ItemStack in2 = new ItemStack((IItemProvider)Items.field_151042_j, 4 + rand.nextInt(4));
            ItemStack out = new ItemStack((IItemProvider)Items.field_221844_ef);
            return new MerchantOffer(in1, in2, out, 10, 10, 0.2f);
        }
    }
}

