/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.module;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import svenhjol.charm.world.block.PigIronOreBlock;
import svenhjol.charm.world.item.PigIronNuggetItem;
import svenhjol.meson.MesonModule;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="World", description="Pig iron ore can be broken for pig iron nuggets or smelted into regular iron.")
public class NetherPigIron
extends MesonModule {
    public static PigIronOreBlock block;
    public static PigIronNuggetItem item;
    @Config(name="Vein size")
    public static int veinSize;
    @Config(name="Cluster count")
    public static int clusterCount;

    @Override
    public void init() {
        block = new PigIronOreBlock(this);
        item = new PigIronNuggetItem(this);
    }

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (biome.func_201856_r() != Biome.Category.NETHER) continue;
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, block.func_176223_P(), veinSize), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(clusterCount, 10, 0, 128)));
        }
    }

    static {
        veinSize = 6;
        clusterCount = 30;
    }
}

