/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.ItemNBTHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="World", hasSubscriptions=true, description="Wandering Traders sell Structure Maps that can be used to find additional overworld structures.")
public class StructureMaps
extends MesonModule {
    @Config(name="Maximum Maps", description="Maximum number of structure map types a trader may sell.")
    public static int maxMaps = 3;
    @Config(name="Villager experience awarded", description="The amount of experience awarded to the trader upon selling.")
    public static int tradeXp = 5;
    @Config(name="Maximum Trades", description="Maximum number of times the trade can be used before it locks.")
    public static int maxTrades = 1;
    @Config(name="General map minimum cost", description="Minimum emerald cost of a general structure map.")
    public static int generalMinCost = 4;
    @Config(name="General map maximum cost", description="Maximum emerald cost of a general structure map.")
    public static int generalMaxCost = 7;
    @Config(name="Biome-specific map minimum cost", description="Minimum emerald cost of a biome-specific structure map.")
    public static int biomeMinCost = 16;
    @Config(name="Biome-specific map maximum cost", description="Maximum emerald cost of a biome-specific structure map.")
    public static int biomeMaxCost = 22;
    public static List<StructureTrade> trades = new ArrayList<StructureTrade>();

    @Override
    public void init() {
        int bmin = biomeMinCost;
        int bmax = biomeMaxCost;
        int gmin = generalMinCost;
        int gmax = generalMaxCost;
        trades.add(new StructureTrade("Desert_Pyramid").setColor(0x866600).setCost(bmin, bmax));
        trades.add(new StructureTrade("Igloo").setColor(10535167).setCost(bmin, bmax));
        trades.add(new StructureTrade("Jungle_Pyramid").setColor(0x20B020).setCost(bmin, bmax));
        trades.add(new StructureTrade("Mineshaft").setColor(0x774400).setCost(gmin, gmax));
        trades.add(new StructureTrade("Ocean_Ruin").setColor(255).setCost(gmin, gmax));
        trades.add(new StructureTrade("Pillager_Outpost").setColor(0xFF0033).setCost(gmin, gmax));
        trades.add(new StructureTrade("Shipwreck").setColor(0x990000).setCost(gmin, gmax));
        trades.add(new StructureTrade("Swamp_Hut").setColor(0x107000).setCost(bmin, bmax));
        trades.add(new StructureTrade("Village").setColor(0xCC2200).setCost(gmin, gmax));
    }

    @SubscribeEvent
    public void onWandererTrades(WandererTradesEvent event) {
        List trades = event.getRareTrades();
        for (int i = 0; i < maxMaps; ++i) {
            trades.add(new StructureMapForEmeraldsTrade());
        }
    }

    public static class StructureTrade {
        public String name;
        public int dimension;
        public int color;
        public int min;
        public int max;

        public StructureTrade(String name) {
            this(name, 0, 0);
        }

        public StructureTrade(String name, int color, int dimension) {
            this.dimension = dimension;
            this.name = name;
            this.color = color;
        }

        public StructureTrade setCost(int min, int max) {
            this.min = min;
            this.max = max;
            return this;
        }

        public StructureTrade setColor(int color) {
            this.color = color;
            return this;
        }
    }

    static class StructureMapForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final MapDecoration.Type targetType = MapDecoration.Type.TARGET_X;
        private final int maxUses = maxTrades;
        private final int tradeXp = tradeXp;

        StructureMapForEmeraldsTrade() {
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity merchant, Random rand) {
            ServerWorld serverWorld;
            BlockPos pos;
            StructureTrade structure = trades.get(rand.nextInt(trades.size()));
            World world = merchant.field_70170_p;
            if (!world.field_72995_K && (pos = (serverWorld = (ServerWorld)world).func_211157_a(structure.name, new BlockPos(merchant), 500, true)) != null) {
                ItemStack stack = FilledMapItem.func_195952_a((World)world, (int)pos.func_177958_n(), (int)pos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_190905_a((World)world, (ItemStack)stack);
                MapData.func_191094_a((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)this.targetType);
                stack.func_200302_a((ITextComponent)new TranslationTextComponent("map.charm." + structure.name.toLowerCase(Locale.ENGLISH), new Object[0]));
                CompoundNBT tag = ItemNBTHelper.getCompound(stack, "display");
                tag.func_74768_a("MapColor", structure.color);
                ItemNBTHelper.setCompound(stack, "display", tag);
                ItemStack in1 = new ItemStack((IItemProvider)Items.field_151166_bC, rand.nextInt(structure.max - structure.min) + structure.min);
                ItemStack in2 = new ItemStack((IItemProvider)Items.field_151111_aL);
                float multiplier = 0.2f;
                return new MerchantOffer(in1, in2, stack, this.maxUses, this.tradeXp, multiplier);
            }
            return null;
        }
    }
}

