/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.compat;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import svenhjol.meson.Meson;
import svenhjol.meson.compat.IQuarkCompat;
import vazkii.quark.api.event.ModuleLoadedEvent;
import vazkii.quark.api.event.ModuleStateChangedEvent;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleLoader;

public class QuarkCompat
implements IQuarkCompat {
    public Map<Class<? extends Module>, Module> foundModules;
    public Map<String, Boolean> modules = new HashMap<String, Boolean>();
    public Map<String, Module> nameMap = new HashMap<String, Module>();

    public QuarkCompat() {
        Object found = ObfuscationReflectionHelper.getPrivateValue(ModuleLoader.class, (Object)ModuleLoader.INSTANCE, (String)"foundModules");
        if (found == null) {
            Meson.LOG.error("Could not get foundModules from Quark ModuleLoader - Quark module checking will NOT be available");
            return;
        }
        this.foundModules = (Map)found;
        for (Module mod : this.foundModules.values()) {
            this.nameMap.put(mod.lowercaseName, mod);
        }
    }

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event, IEventBus forgeEventBus) {
        forgeEventBus.addListener(this::onModuleLoaded);
        forgeEventBus.addListener(this::onModuleStateChanged);
    }

    private void onModuleLoaded(ModuleLoadedEvent event) {
        this.modules.put(event.eventName, false);
    }

    private void onModuleStateChanged(ModuleStateChangedEvent event) {
        this.modules.put(event.eventName, event.enabled);
    }

    @Override
    public boolean isModuleEnabled(String name) {
        return this.nameMap.containsKey(name) && this.nameMap.get((Object)name).enabled;
    }

    @Override
    public boolean isModulePresent(String name) {
        return this.nameMap.containsKey(name);
    }
}

