/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.loader;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonInstance;
import svenhjol.meson.MesonModule;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

public class ModuleLoader {
    private static final String MOD = "mod";
    private static final String CATEGORY = "category";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String HAS_SUBSCRIPTIONS = "hasSubscriptions";
    private static final String ENABLED_BY_DEFAULT = "enabledByDefault";
    private static final String ALWAYS_ENABLED = "alwaysEnabled";
    private static final String CLIENT = "client";
    private static final String SERVER = "server";
    private static final Type LOAD_MODULE = Type.getType(Module.class);
    private MesonInstance instance;
    private ModConfig config;
    private List<MesonModule> modules = new ArrayList<MesonModule>();
    private List<Runnable> refreshConfig = new ArrayList<Runnable>();
    private List<Runnable> refreshShouldRunSetup = new ArrayList<Runnable>();
    private List<MesonModule> enabledModules = new ArrayList<MesonModule>();
    private Map<String, MesonModule> enabledModulesByIndex = new TreeMap<String, MesonModule>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<MesonModule>> categories = new HashMap<String, List<MesonModule>>();

    public ModuleLoader(MesonInstance instance) {
        this.instance = instance;
        this.setupModules();
        this.setupConfig();
    }

    private void setupModules() {
        ModFileScanData result = ModList.get().getModFileById(this.instance.getId()).getFile().getScanResult();
        List<ModFileScanData.AnnotationData> targets = result.getAnnotations().stream().filter(annotationData -> LOAD_MODULE.equals((Object)annotationData.getAnnotationType())).collect(Collectors.toList());
        targets.forEach(target -> {
            try {
                String moduleClass = target.getClassType().getClassName();
                Map data = target.getAnnotationData();
                if (data.containsKey(CLIENT) && !((Boolean)data.get(CLIENT)).booleanValue() && FMLEnvironment.dist == Dist.CLIENT) {
                    return;
                }
                if (data.containsKey(SERVER) && !((Boolean)data.get(SERVER)).booleanValue() && FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
                    return;
                }
                MesonModule module = (MesonModule)Class.forName(moduleClass).newInstance();
                module.mod = (String)data.get(MOD);
                module.category = (String)data.get(CATEGORY);
                module.name = data.containsKey(NAME) ? (String)data.get(NAME) : module.getClass().getSimpleName();
                module.description = data.containsKey(DESCRIPTION) ? (String)data.get(DESCRIPTION) : "";
                module.hasSubscriptions = data.containsKey(HAS_SUBSCRIPTIONS) ? (Boolean)data.get(HAS_SUBSCRIPTIONS) : false;
                module.enabledByDefault = data.containsKey(ENABLED_BY_DEFAULT) ? (Boolean)data.get(ENABLED_BY_DEFAULT) : true;
                boolean bl = module.alwaysEnabled = data.containsKey(ALWAYS_ENABLED) ? (Boolean)data.get(ALWAYS_ENABLED) : false;
                if (!this.categories.containsKey(module.category)) {
                    this.categories.put(module.category, new ArrayList());
                }
                this.categories.get(module.category).add(module);
                this.modules.add(module);
                this.instance.log.debug("Instantiated module: " + module.getName());
            }
            catch (ReflectiveOperationException e) {
                Meson.LOG.error("Failed to load module: " + target.toString());
            }
        });
    }

    private void setupConfig() {
        ForgeConfigSpec spec = (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(this::build).getRight();
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        this.config = new ModConfig(ModConfig.Type.COMMON, spec, container);
        container.addConfig(this.config);
        this.earlyConfigHack();
        this.refreshConfig();
    }

    private void earlyConfigHack() {
        Path path = FMLPaths.CONFIGDIR.get();
        if (path == null) {
            this.instance.log.warn("Could not fetch config dir path");
            return;
        }
        String name = this.config.getFileName();
        if (name == null) {
            this.instance.log.warn("Could not fetch mod config filename");
            return;
        }
        Path configPath = Paths.get(path.toString() + File.separator + name, new String[0]);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            this.instance.log.warn("Config file does not exist: " + path);
            return;
        }
        try {
            List<String> lines = Files.readAllLines(configPath);
            block2: for (String line : lines) {
                if (!line.contains("enabled")) continue;
                for (MesonModule mod : this.getModules()) {
                    if (!line.contains(mod.name)) continue;
                    if (line.contains("false")) {
                        mod.enabled = false;
                        continue block2;
                    }
                    if (!line.contains("true")) continue block2;
                    mod.enabled = true;
                    continue block2;
                }
            }
            this.instance.log.debug("Finished early loading config");
        }
        catch (Exception e) {
            this.instance.log.warn("Could not read config file: " + e);
        }
    }

    private Void build(ForgeConfigSpec.Builder builder) {
        this.getCategories().forEach((category, modules) -> {
            builder.push(category);
            this.buildCategory(builder, (List<MesonModule>)modules);
            builder.pop();
        });
        return null;
    }

    private void buildCategory(ForgeConfigSpec.Builder builder, List<MesonModule> modules) {
        modules.forEach(module -> {
            this.instance.log.info("Creating config for module " + module.getName());
            if (module.alwaysEnabled) {
                module.enabled = true;
                this.addEnabledModule((MesonModule)module);
            } else {
                if (!module.description.isEmpty()) {
                    builder.comment(module.description);
                }
                ForgeConfigSpec.BooleanValue val = builder.define(module.getName() + " enabled", module.enabledByDefault);
                this.refreshConfig.add(() -> this.lambda$null$3(module, (ForgeConfigSpec.ConfigValue)val));
            }
            this.refreshShouldRunSetup.add(() -> {
                module.enabled = module.enabled && module.shouldRunSetup();
                this.addEnabledModule((MesonModule)module);
            });
        });
        modules.forEach(module -> {
            builder.push(module.getName());
            this.buildModule(builder, (MesonModule)module);
            builder.pop();
        });
    }

    private void buildModule(ForgeConfigSpec.Builder builder, MesonModule module) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(module.getClass().getDeclaredFields()));
        fields.forEach(field -> {
            Config config = field.getDeclaredAnnotation(Config.class);
            if (config != null) {
                this.pushConfig(builder, module, (Field)field, config);
            }
        });
    }

    private void pushConfig(ForgeConfigSpec.Builder builder, MesonModule module, Field field, Config config) {
        String description;
        field.setAccessible(true);
        String name = config.name();
        if (name.isEmpty()) {
            name = field.getName();
        }
        if (!(description = config.description()).isEmpty()) {
            builder.comment(description);
        }
        try {
            Object defaultValue = field.get(null);
            ForgeConfigSpec.ConfigValue value = defaultValue instanceof List ? builder.defineList(name, (List)defaultValue, o -> true) : builder.define(name, defaultValue);
            this.refreshConfig.add(() -> {
                try {
                    field.set(null, value.get());
                }
                catch (IllegalAccessException e) {
                    Meson.LOG.error("Could not set config value for " + module.getName());
                    throw new RuntimeException(e);
                }
            });
        }
        catch (ReflectiveOperationException e) {
            Meson.LOG.error("Failed to get config for " + module.getName());
        }
    }

    public void refreshConfig() {
        this.refreshConfig.forEach(Runnable::run);
    }

    public void refreshShouldRunSetup() {
        this.refreshShouldRunSetup.forEach(Runnable::run);
    }

    public Map<String, List<MesonModule>> getCategories() {
        return this.categories;
    }

    public List<MesonModule> getModules() {
        return this.modules;
    }

    public List<MesonModule> getEnabledModules() {
        return this.enabledModules;
    }

    public boolean isModuleEnabled(String module) {
        return this.enabledModulesByIndex.containsKey(module);
    }

    public MesonModule getModule(String module) {
        return this.enabledModulesByIndex.get(module);
    }

    private void addEnabledModule(MesonModule module) {
        if (module.enabled && !this.enabledModules.contains(module)) {
            this.enabledModules.add(module);
            this.enabledModulesByIndex.put(module.getName(), module);
        } else if (!module.enabled) {
            this.enabledModules.remove(module);
            this.enabledModulesByIndex.remove(module.getName());
        }
    }

    private /* synthetic */ void lambda$null$3(MesonModule module, ForgeConfigSpec.ConfigValue val) {
        module.enabled = (Boolean)val.get();
        this.addEnabledModule(module);
    }
}

