/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.compat;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.DyeColor;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import svenhjol.charm.base.compat.IQuarkCompat;
import svenhjol.meson.Meson;
import svenhjol.meson.enums.ColorVariant;
import svenhjol.meson.enums.VanillaWoodType;
import svenhjol.meson.helper.ItemNBTHelper;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.module.VariantChestsModule;
import vazkii.quark.tools.item.RuneItem;
import vazkii.quark.tools.module.AncientTomesModule;
import vazkii.quark.tools.module.ColorRunesModule;
import vazkii.quark.world.block.CaveCrystalBlock;
import vazkii.quark.world.module.BigDungeonModule;

public class QuarkCompat
implements IQuarkCompat {
    @Override
    public boolean hasColorRuneModule() {
        return ModuleLoader.INSTANCE.isModuleEnabled(ColorRunesModule.class);
    }

    @Override
    public boolean isRune(ItemStack stack) {
        return stack.func_77973_b() instanceof RuneItem;
    }

    @Override
    @Nullable
    public ColorVariant getRuneColor(ItemStack stack) {
        ColorVariant color = ColorVariant.WHITE;
        if (this.isRune(stack)) {
            RuneItem item = (RuneItem)stack.func_77973_b();
            ResourceLocation itemRegName = item.getRegistryName();
            if (itemRegName == null) {
                return null;
            }
            String colorName = itemRegName.func_110623_a().replace("_rune", "").toUpperCase();
            try {
                color = ColorVariant.valueOf(colorName);
            }
            catch (Exception e) {
                Meson.LOG.debug("Failed to get color of rune" + stack.func_77973_b());
                return null;
            }
        }
        return color;
    }

    @Override
    public ItemStack getRune(ColorVariant color) {
        ResourceLocation res = new ResourceLocation("quark", color.func_176610_l() + "_rune");
        Item runeItem = (Item)ForgeRegistries.ITEMS.getValue(res);
        return runeItem == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)runeItem);
    }

    @Override
    public ItemStack getQuiltedWool(ColorVariant color) {
        Item item;
        if (Meson.isModuleEnabled(new ResourceLocation("quark:quilted_wool")) && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("quark:" + color.func_176610_l() + "_quilted_wool"))) != null) {
            return new ItemStack((IItemProvider)item);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void applyColor(ItemStack stack, DyeColor color) {
        Item runeItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("quark", color.func_176610_l() + "_rune"));
        if (runeItem instanceof RuneItem) {
            ItemStack rune = new ItemStack((IItemProvider)runeItem);
            ItemNBTHelper.setBoolean(stack, "quark:RuneAttached", true);
            ItemNBTHelper.setCompound(stack, "quark:RuneColor", rune.serializeNBT());
        }
    }

    @Override
    public ItemStack getRandomAncientTome(Random rand) {
        List validEnchants = AncientTomesModule.validEnchants;
        ItemStack tome = new ItemStack((IItemProvider)AncientTomesModule.ancient_tome);
        Enchantment enchantment = (Enchantment)validEnchants.get(rand.nextInt(validEnchants.size()));
        EnchantedBookItem.func_92115_a((ItemStack)tome, (EnchantmentData)new EnchantmentData(enchantment, enchantment.func_77325_b()));
        return tome;
    }

    @Override
    public boolean isInsideBigDungeon(ServerWorld world, BlockPos pos) {
        return BigDungeonModule.structure.func_202366_b((IWorld)world, pos);
    }

    @Override
    public boolean isCrystal(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof CaveCrystalBlock;
    }

    @Override
    public boolean hasVariantChests() {
        return ModuleLoader.INSTANCE.isModuleEnabled(VariantChestsModule.class);
    }

    @Override
    public boolean hasBigDungeons() {
        return ModuleLoader.INSTANCE.isModuleEnabled(BigDungeonModule.class);
    }

    @Override
    public String getBigDungeonResName() {
        if (BigDungeonModule.structure != null) {
            return BigDungeonModule.structure.func_143025_a();
        }
        return "quark:big_dungeon";
    }

    @Override
    public Structure<?> getBigDungeonStructure() {
        return BigDungeonModule.structure;
    }

    @Override
    @Nullable
    public Block getRandomChest(Random rand) {
        List<VanillaWoodType> types = Arrays.asList(VanillaWoodType.values());
        VanillaWoodType type = types.get(rand.nextInt(types.size()));
        ResourceLocation res = new ResourceLocation("quark", type.name().toLowerCase() + "_chest");
        return (Block)ForgeRegistries.BLOCKS.getValue(res);
    }
}

