/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.integration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import svenhjol.charm.enchanting.module.CurseBreak;
import svenhjol.charm.tools.item.BoundCompassItem;
import svenhjol.charm.tools.module.CompassBinding;
import svenhjol.charm.world.module.NetherPigIron;
import svenhjol.meson.Meson;

@JeiPlugin
public class CharmJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("charm", "charm");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        if (Meson.isModuleEnabled("charm:dimensional_compass")) {
            this.registerDimensionalCompass(registration, factory);
        }
        if (Meson.isModuleEnabled("charm:pig_iron_increases_durability")) {
            this.registerPigIronRepair(registration, factory);
        }
        if (Meson.isModuleEnabled("charm:extract_enchantments")) {
            this.registerExtractEnchantments(registration, factory);
        }
        if (Meson.isModuleEnabled("charm:curse_break")) {
            this.registerCurseBreak(registration, factory);
        }
    }

    private void registerDimensionalCompass(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        ItemStack boundCompass = new ItemStack((IItemProvider)CompassBinding.item);
        ItemStack dimensionalCompass = boundCompass.func_77946_l();
        dimensionalCompass.func_200302_a((ITextComponent)new TranslationTextComponent("item.charm.dimensional_compass", new Object[0]));
        BoundCompassItem.setDimensional(dimensionalCompass, true);
        recipes.add(factory.createAnvilRecipe(boundCompass, Collections.singletonList(new ItemStack((IItemProvider)Items.field_151061_bv)), Collections.singletonList(dimensionalCompass)));
        registration.addRecipes(recipes, VanillaRecipeCategoryUid.ANVIL);
    }

    private void registerPigIronRepair(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        ItemStack damagedPick = new ItemStack((IItemProvider)Items.field_151046_w);
        damagedPick.func_196085_b(1000);
        ItemStack repairedPick = damagedPick.func_77946_l();
        repairedPick.func_196085_b(900);
        recipes.add(factory.createAnvilRecipe(damagedPick, Collections.singletonList(new ItemStack((IItemProvider)NetherPigIron.item)), Collections.singletonList(repairedPick)));
        registration.addRecipes(recipes, VanillaRecipeCategoryUid.ANVIL);
    }

    private void registerExtractEnchantments(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        final Enchantment enchant = Enchantments.field_185307_s;
        ItemStack pick1 = new ItemStack((IItemProvider)Items.field_151046_w);
        ItemStack book1 = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantmentHelper.func_82782_a((Map)new HashMap<Enchantment, Integer>(){
            {
                this.put(enchant, 2);
            }
        }, (ItemStack)pick1);
        EnchantmentHelper.func_82782_a((Map)new HashMap<Enchantment, Integer>(){
            {
                this.put(enchant, 1);
            }
        }, (ItemStack)book1);
        ItemStack pick2 = new ItemStack((IItemProvider)Items.field_151046_w);
        ItemStack book2 = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantmentHelper.func_82782_a((Map)new HashMap<Enchantment, Integer>(){
            {
                this.put(enchant, 1);
            }
        }, (ItemStack)pick2);
        EnchantmentHelper.func_82782_a((Map)new HashMap<Enchantment, Integer>(){
            {
                this.put(enchant, 1);
            }
        }, (ItemStack)book2);
        recipes.add(factory.createAnvilRecipe(pick1, Collections.singletonList(new ItemStack((IItemProvider)Items.field_151122_aG)), Collections.singletonList(book1)));
        recipes.add(factory.createAnvilRecipe(pick2, Collections.singletonList(new ItemStack((IItemProvider)Items.field_151122_aG)), Collections.singletonList(book2)));
        registration.addRecipes(recipes, VanillaRecipeCategoryUid.ANVIL);
    }

    private void registerCurseBreak(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        ItemStack normal = new ItemStack((IItemProvider)Items.field_151046_w);
        ItemStack cursed = new ItemStack((IItemProvider)Items.field_151046_w);
        EnchantmentHelper.func_82782_a((Map)new HashMap<Enchantment, Integer>(){
            {
                this.put(Enchantments.field_190940_C, 1);
            }
        }, (ItemStack)cursed);
        ItemStack curseBreak = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantmentHelper.func_82782_a((Map)new HashMap<Enchantment, Integer>(){
            {
                this.put(CurseBreak.enchantment, 1);
            }
        }, (ItemStack)curseBreak);
        recipes.add(factory.createAnvilRecipe(cursed, Collections.singletonList(curseBreak), Collections.singletonList(normal)));
        registration.addRecipes(recipes, VanillaRecipeCategoryUid.ANVIL);
    }
}

