/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.decoration.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import svenhjol.charm.decoration.block.CrateBaseBlock;
import svenhjol.charm.decoration.module.Crates;
import svenhjol.charm.decoration.tileentity.CrateTileEntity;
import svenhjol.meson.MesonModule;
import svenhjol.meson.enums.IWoodType;

public class CrateOpenBlock
extends CrateBaseBlock {
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");

    public CrateOpenBlock(MesonModule module, IWoodType wood) {
        super(module, "crate_open_" + wood.func_176610_l(), wood);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_175149_v()) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof CrateTileEntity) {
            CrateTileEntity crate = (CrateTileEntity)tile;
            crate.func_184281_d(player);
            player.func_213829_a((INamedContainerProvider)crate);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof CrateTileEntity) {
            CrateTileEntity crate = (CrateTileEntity)tile;
            if (!world.field_72995_K && player.func_184812_l_()) {
                ItemStack stack = new ItemStack((IItemProvider)CrateOpenBlock.getBlockByWood(this.wood));
                CompoundNBT tag = crate.func_189515_b(new CompoundNBT());
                if (!tag.isEmpty()) {
                    stack.func_77983_a("BlockEntityTag", (INBT)tag);
                }
                if (crate.func_145818_k_()) {
                    stack.func_200302_a(crate.func_200201_e());
                }
                ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                entity.func_174869_p();
                world.func_217376_c((Entity)entity);
            } else {
                crate.func_184281_d(player);
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof CrateTileEntity) {
            CrateTileEntity crate = (CrateTileEntity)tile;
            builder = builder.func_216017_a(CONTENTS, (context, consumer) -> {
                for (int i = 0; i < crate.func_70302_i_(); ++i) {
                    consumer.accept(crate.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(state, builder);
    }

    public static Block getBlockByWood(IWoodType wood) {
        return Crates.openTypes.get(wood);
    }
}

