/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.decoration.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ObjectHolder;
import svenhjol.charm.decoration.block.CrateBaseBlock;
import svenhjol.charm.decoration.block.CrateOpenBlock;
import svenhjol.charm.decoration.block.CrateSealedBlock;
import svenhjol.charm.decoration.client.CratesClient;
import svenhjol.charm.decoration.container.CrateContainer;
import svenhjol.charm.decoration.inventory.CrateScreen;
import svenhjol.charm.decoration.tileentity.CrateTileEntity;
import svenhjol.meson.MesonModule;
import svenhjol.meson.enums.IWoodType;
import svenhjol.meson.enums.VanillaWoodType;
import svenhjol.meson.handler.RegistryHandler;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Decoration", hasSubscriptions=true, description="A smaller storage solution with the benefit of being transportable.\nYou can also seal a crate by combining it with an iron ingot on an anvil.  The only way to get things out is to break it.")
public class Crates
extends MesonModule {
    public static Map<IWoodType, CrateOpenBlock> openTypes = new HashMap<IWoodType, CrateOpenBlock>();
    public static Map<IWoodType, CrateSealedBlock> sealedTypes = new HashMap<IWoodType, CrateSealedBlock>();
    public static List<Class<? extends Block>> invalidBlocks = new ArrayList<Class<? extends Block>>();
    public static List<Class<? extends Item>> invalidItems = new ArrayList<Class<? extends Item>>();
    @ObjectHolder(value="charm:crate")
    public static ContainerType<CrateContainer> container;
    @ObjectHolder(value="charm:crate")
    public static TileEntityType<CrateTileEntity> tile;
    public static CratesClient client;

    @Override
    public void init() {
        for (VanillaWoodType wood : VanillaWoodType.values()) {
            openTypes.put(wood, new CrateOpenBlock(this, wood));
            sealedTypes.put(wood, new CrateSealedBlock(this, wood));
        }
        invalidBlocks.add(ShulkerBoxBlock.class);
        invalidBlocks.add(CrateOpenBlock.class);
        invalidBlocks.add(CrateSealedBlock.class);
        ResourceLocation res = new ResourceLocation("charm", "crate");
        container = new ContainerType(CrateContainer::instance);
        tile = TileEntityType.Builder.func_223042_a(CrateTileEntity::new, (Block[])new Block[0]).func_206865_a(null);
        RegistryHandler.registerContainer(container, res);
        RegistryHandler.registerTile(tile, res);
    }

    @Override
    public void onClientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(container, CrateScreen::new);
        client = new CratesClient();
        MinecraftForge.EVENT_BUS.register((Object)client);
    }

    public static boolean canInsertItem(ItemStack stack) {
        Class<?> blockClass = Block.func_149634_a((Item)stack.func_77973_b()).getClass();
        return !invalidItems.contains(stack.func_77973_b().getClass()) && !invalidBlocks.contains(blockClass);
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        ItemStack out = event.getOutput();
        if (left.func_190926_b() || right.func_190926_b()) {
            return;
        }
        Block block = Block.func_149634_a((Item)left.func_77973_b());
        if (!(block instanceof CrateBaseBlock)) {
            return;
        }
        if (right.func_77973_b() == Items.field_151042_j && block instanceof CrateOpenBlock) {
            IWoodType wood = ((CrateOpenBlock)block).getWood();
            out = new ItemStack((IItemProvider)sealedTypes.get(wood));
            out.func_77982_d(left.func_77978_p());
            out.func_200302_a(left.func_200301_q());
        }
        if (!out.func_190926_b()) {
            event.setOutput(out);
            event.setCost(1);
            event.setMaterialCost(1);
        }
    }
}

