/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.decoration.module;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import svenhjol.charm.decoration.render.CustomWolfRenderer;
import svenhjol.meson.MesonModule;
import svenhjol.meson.iface.IMesonEnum;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Decoration", description="Wolves will spawn with texture variants.")
public class RandomAnimalTextures
extends MesonModule {
    public static List<String> wolves = Arrays.asList("minecraft:wolf", "charm:brownwolf", "charm:greywolf", "charm:blackwolf", "charm:amotwolf", "charm:jupiter1390");

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientSetup(FMLClientSetupEvent event) {
        if (this.enabled) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200724_aC, (IRenderFactory)CustomWolfRenderer.factory());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation getWolfTexture(WolfEntity entity) {
        String texture = RandomAnimalTextures.getRandomTexture((Entity)entity, wolves);
        if (entity.func_70909_n()) {
            texture = texture + "_tame";
        } else if (entity.func_70919_bu()) {
            texture = texture + "_angry";
        }
        return RandomAnimalTextures.getTextureFromString(MobType.WOLF, texture);
    }

    public static String getRandomTexture(Entity entity, List<String> set) {
        UUID id = entity.func_110124_au();
        int choice = Math.abs((int)(id.getMostSignificantBits() % (long)set.size()));
        return set.get(choice);
    }

    public static ResourceLocation getTextureFromString(MobType type, String texture) {
        String prefix = "textures/entity/" + type.func_176610_l() + "/";
        String[] a = texture.split(":");
        return new ResourceLocation(a[0], prefix + a[1] + ".png");
    }

    public static enum MobType implements IMesonEnum
    {
        WOLF;

    }
}

