/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tools.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import svenhjol.charm.Charm;
import svenhjol.meson.MesonItem;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.ItemNBTHelper;

public class BoundCompassItem
extends MesonItem {
    private static final String POS = "pos";
    private static final String DIM = "dim";
    private static final String COLOR = "color";
    private static final String DIMENSIONAL = "dimensional";
    private static final String ROTA = "rota";
    private static final String ROTATION = "rotation";
    private static final String LASTUPDATE = "lastUpdateTick";

    public BoundCompassItem(MesonModule module) {
        super(module, "bound_compass", new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            public float call(ItemStack stack, @Nullable World world, @Nullable LivingEntity entityIn) {
                double angle;
                boolean validDimension;
                LivingEntity entity;
                if (entityIn == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean hasEntity = entityIn != null;
                Object object = entity = hasEntity ? entityIn : stack.func_82836_z();
                if (world == null) {
                    world = ((Entity)Objects.requireNonNull(entity)).field_70170_p;
                }
                boolean isDimensional = BoundCompassItem.isDimensional(stack);
                int currentDim = world.func_201675_m().func_186058_p().func_186068_a();
                BlockPos pos = BoundCompassItem.getPos(stack);
                int dim = BoundCompassItem.getDim(stack);
                if (pos != null) {
                    validDimension = currentDim == dim;
                } else {
                    pos = world.func_175694_M();
                    boolean bl = validDimension = currentDim == 0;
                }
                if (isDimensional) {
                    pos = BoundCompassItem.this.translatePosForDimension((IWorld)world, pos, stack);
                }
                if (validDimension || isDimensional) {
                    double yaw = hasEntity ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)Objects.requireNonNull(entity));
                    yaw = MathHelper.func_191273_b((double)(yaw / 360.0), (double)1.0);
                    double relAngle = this.getPosToAngle((Entity)entity, pos) / (Math.PI * 2);
                    angle = this.wobble(world, stack, 0.5 - (yaw - 0.25 - relAngle));
                } else {
                    angle = this.wobbleRandomly(world, stack, Math.random());
                }
                return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobbleRandomly(World worldIn, ItemStack stack, double angle) {
                if (!stack.func_77942_o()) {
                    return 0.0;
                }
                if (worldIn.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = worldIn.func_82737_E();
                    double d0 = angle - this.rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(World worldIn, ItemStack stack, double angle) {
                if (!stack.func_77942_o()) {
                    return 0.0;
                }
                double rotation = ItemNBTHelper.getDouble(stack, BoundCompassItem.ROTATION, 0.0);
                double rota = ItemNBTHelper.getDouble(stack, BoundCompassItem.ROTA, 0.0);
                long lastUpdateTick = ItemNBTHelper.getLong(stack, BoundCompassItem.LASTUPDATE, 0L);
                double oldRotation = rotation;
                double oldRota = rota;
                if (worldIn.func_82737_E() != lastUpdateTick) {
                    double d0 = angle - rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    rota += d0 * 0.1;
                    rotation = MathHelper.func_191273_b((double)(rotation + (rota *= 0.8)), (double)1.0);
                }
                if ((double)Math.round(rota * 100.0) / 100.0 != (double)Math.round(oldRota * 100.0) / 100.0 || (double)Math.round(rotation * 100.0) / 100.0 != (double)Math.round(oldRotation * 100.0) / 100.0) {
                    lastUpdateTick = worldIn.func_82737_E();
                    ItemNBTHelper.setLong(stack, BoundCompassItem.LASTUPDATE, lastUpdateTick);
                    ItemNBTHelper.setDouble(stack, BoundCompassItem.ROTATION, rotation);
                    ItemNBTHelper.setDouble(stack, BoundCompassItem.ROTA, rota);
                }
                return rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrameEntity frame) {
                return MathHelper.func_188209_b((int)(180 + Objects.requireNonNull(frame.func_174811_aO()).func_176736_b() * 90));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getPosToAngle(Entity entity, BlockPos pos) {
                BlockPos entityPos = entity.func_180425_c();
                return Math.atan2(pos.func_177952_p() - entityPos.func_177952_p(), pos.func_177958_n() - entityPos.func_177958_n());
            }
        });
    }

    public static int getColor(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, COLOR, 0);
    }

    public static int getDim(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, DIM, 0);
    }

    public static boolean isDimensional(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, DIMENSIONAL, false);
    }

    @Nullable
    public static BlockPos getPos(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        long pos = ItemNBTHelper.getLong(stack, POS, 0L);
        return BlockPos.func_218283_e((long)pos);
    }

    public static void setColor(ItemStack stack, int color) {
        ItemNBTHelper.setInt(stack, COLOR, color);
        if (Charm.quarkCompat != null && Charm.quarkCompat.hasColorRuneModule()) {
            Charm.quarkCompat.applyColor(stack, DyeColor.func_196056_a((int)color));
        }
    }

    public static void setDim(ItemStack stack, int dim) {
        ItemNBTHelper.setInt(stack, DIM, dim);
    }

    public static void setPos(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setLong(stack, POS, pos.func_218275_a());
    }

    public static void setDimensional(ItemStack stack, boolean isDimensional) {
        ItemNBTHelper.setBoolean(stack, DIMENSIONAL, isDimensional);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> textComponents, ITooltipFlag flag) {
        BlockPos pos = this.translatePosForDimension((IWorld)world, BoundCompassItem.getPos(stack), stack);
        if (pos != null) {
            String x = String.valueOf(pos.func_177958_n());
            String z = String.valueOf(pos.func_177952_p());
            int dim = BoundCompassItem.getDim(stack);
            textComponents.add((ITextComponent)new TranslationTextComponent("gui.charm.bound_compass_location", new Object[]{x, z, dim}));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return BoundCompassItem.isDimensional(stack);
    }

    public BlockPos translatePosForDimension(IWorld world, BlockPos pos, ItemStack stack) {
        if (BoundCompassItem.isDimensional(stack) && world != null && pos != null) {
            if (BoundCompassItem.getDim(stack) == 0 && this.getCurrentDimensionId(world) == -1) {
                pos = this.translateOverworldToNether(pos);
            } else if (BoundCompassItem.getDim(stack) == -1 && this.getCurrentDimensionId(world) == 0) {
                pos = this.translateNetherToOverworld(pos);
            }
        }
        return pos;
    }

    public BlockPos translateOverworldToNether(BlockPos pos) {
        return new BlockPos(pos.func_177958_n() / 8, pos.func_177956_o(), pos.func_177952_p() / 8);
    }

    public BlockPos translateNetherToOverworld(BlockPos pos) {
        return new BlockPos(pos.func_177958_n() * 8, pos.func_177956_o(), pos.func_177952_p() * 8);
    }

    public int getCurrentDimensionId(IWorld world) {
        return world.func_201675_m().func_186058_p().func_186068_a();
    }
}

