/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.module;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.Charm;
import svenhjol.meson.MesonModule;
import svenhjol.meson.enums.ColorVariant;
import svenhjol.meson.helper.CauldronHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Tweaks", hasSubscriptions=true, description="Filled cauldrons can be used to clean certain blocks.")
public class CauldronCleansThings
extends MesonModule {
    @Config(name="Clean sticky pistons", description="Sticky pistons become normal pistons.")
    public static boolean stickyPistons = true;
    @Config(name="Clean colored wool", description="Colored wool becomes white wool.")
    public static boolean wool = true;
    @Config(name="Clean colored carpet", description="Colored carpet becomes white carpet.")
    public static boolean carpet = true;
    @Config(name="Clean quilted wool", description="If Quark's Quilted Wool module is enabled, colored quilted wool becomes white quilted wool.")
    public static boolean quiltedWool = true;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCauldronUse(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150383_bp && event.getPlayer() != null && event.getPlayer().func_184586_b(event.getHand()) != ItemStack.field_190927_a) {
            PlayerEntity player = event.getPlayer();
            World world = player.field_70170_p;
            BlockPos pos = event.getPos();
            ItemStack held = player.func_184586_b(event.getHand());
            BlockState state = event.getWorld().func_180495_p(event.getPos());
            ResourceLocation res = held.func_77973_b().getRegistryName();
            Hand hand = event.getHand();
            ItemStack replace = null;
            if (!CauldronHelper.isFull(state)) {
                return;
            }
            if (res == null) {
                return;
            }
            String path = res.func_110623_a();
            String name = res.func_110624_b();
            if (stickyPistons && name.equals("minecraft") && path.equals("sticky_piston")) {
                replace = new ItemStack((IItemProvider)Blocks.field_150331_J);
            } else if (wool && name.equals("minecraft") && path.contains("_wool") && !path.equals("white_wool")) {
                replace = new ItemStack((IItemProvider)Blocks.field_196556_aL);
            } else if (carpet && name.equals("minecraft") && path.contains("_carpet") && !path.equals("white_carpet")) {
                replace = new ItemStack((IItemProvider)Blocks.field_196724_fH);
            } else if (quiltedWool && Charm.quarkCompat != null && name.equals("quark") && path.contains("_quilted_wool")) {
                replace = Charm.quarkCompat.getQuiltedWool(ColorVariant.WHITE);
            }
            if (replace != null) {
                player.func_184611_a(hand, replace);
                CauldronHelper.clearCauldron((IWorld)world, pos, state);
                world.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }
}

