/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.message;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import svenhjol.charm.world.module.EndPortalRunes;
import svenhjol.meson.iface.IMesonMessage;

public class ClientRunePortalAction
implements IMesonMessage {
    public static final int LINKED = 0;
    public static final int UNLINKED = 1;
    public static final int TRAVELLED = 2;
    private BlockPos pos;
    private int action;

    public ClientRunePortalAction(int action, BlockPos pos) {
        this.action = action;
        this.pos = pos;
    }

    public static void encode(ClientRunePortalAction msg, PacketBuffer buf) {
        buf.writeInt(msg.action);
        buf.writeLong(msg.pos.func_218275_a());
    }

    public static ClientRunePortalAction decode(PacketBuffer buf) {
        int action = buf.readInt();
        BlockPos pos = BlockPos.func_218283_e((long)buf.readLong());
        return new ClientRunePortalAction(action, pos);
    }

    public static class Handler {
        public static void handle(ClientRunePortalAction msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                switch (msg.action) {
                    case 0: {
                        EndPortalRunes.effectPortalLinked(msg.pos);
                        break;
                    }
                    case 1: {
                        EndPortalRunes.effectPortalUnlinked(msg.pos);
                        break;
                    }
                    case 2: {
                        EndPortalRunes.effectPortalTravelled(msg.pos);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

