/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.WorldHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="World", hasSubscriptions=true, description="Allows additional hostile mobs to spawn inside world structures.\nIf allow normal mob spawns is false, only mobs specified in additional spawns will appear.")
public class AdditionalMobsInStructures
extends MesonModule {
    public static Map<WorldHelper.Structure, List<Biome.SpawnListEntry>> entries = new HashMap<WorldHelper.Structure, List<Biome.SpawnListEntry>>();
    public static Map<WorldHelper.Structure, Boolean> normalSpawns = new HashMap<WorldHelper.Structure, Boolean>();
    @Config(name="Desert pyramid additional spawns")
    public static List<String> desertPyramidAdded = new ArrayList<String>(){
        {
            this.add("husk=100");
        }
    };
    @Config(name="Desert pyramids allow normal mob spawns")
    public static boolean desertPyramidNormal = false;
    @Config(name="End city additional spawns")
    public static List<String> endCityAdded = new ArrayList<String>();
    @Config(name="End cities allow normal mob spawns")
    public static boolean endCityNormal = true;
    @Config(name="Igloo additional spawns")
    public static List<String> iglooAdded = new ArrayList<String>();
    @Config(name="Igloos allow normal mob spawns")
    public static boolean iglooNormal = true;
    @Config(name="Jungle temple additional spawns")
    public static List<String> jungleTempleAdded = new ArrayList<String>();
    @Config(name="Jungle temples allow normal mob spawns")
    public static boolean jungleTempleNormal = true;
    @Config(name="Mineshaft additional spawns")
    public static List<String> mineshaftAdded = new ArrayList<String>();
    @Config(name="Mineshafts allow normal mob spawns")
    public static boolean mineshaftNormal = true;
    @Config(name="Nether fortress additional spawns")
    public static List<String> netherFortressAdded = new ArrayList<String>();
    @Config(name="Nether fortresses allow normal mob spawns")
    public static boolean netherFortressNormal = true;
    @Config(name="Ocean monument additional spawns")
    public static List<String> oceanMonumentAdded = new ArrayList<String>();
    @Config(name="Ocean monuments allow normal mob spawns")
    public static boolean oceanMonumentNormal = true;
    @Config(name="Ocean ruin additional spawns")
    public static List<String> oceanRuinAdded = new ArrayList<String>();
    @Config(name="Ocean ruins allow normal mob spawns")
    public static boolean oceanRuinNormal = true;
    @Config(name="Pillager outpost additional spawns")
    public static List<String> pillagerOutpostAdded = new ArrayList<String>();
    @Config(name="Pillager outposts allow normal mob spawns")
    public static boolean pillagerOutpostNormal = true;
    @Config(name="Shipwreck additional spawns")
    public static List<String> shipwreckAdded = new ArrayList<String>();
    @Config(name="Shipwrecks allow normal mob spawns")
    public static boolean shipwreckNormal = true;
    @Config(name="Stronghold additional spawns")
    public static List<String> strongholdAdded = new ArrayList<String>();
    @Config(name="Strongholds allow normal mob spawns")
    public static boolean strongholdNormal = true;
    @Config(name="Swamp hut additional spawns")
    public static List<String> swampHutAdded = new ArrayList<String>();
    @Config(name="Swamp huts allow normal mob spawns")
    public static boolean swampHutNormal = true;
    @Config(name="Village additional spawns")
    public static List<String> villageAdded = new ArrayList<String>();
    @Config(name="Villages allow normal mob spawns")
    public static boolean villageNormal = true;
    @Config(name="Woodland mansion additional spawns")
    public static List<String> woodlandMansionAdded = new ArrayList<String>(){
        {
            this.add("vindicator=100");
        }
    };
    @Config(name="Woodland mansions allow normal mob spawns")
    public static boolean woodlandMansionNormal = true;

    @Override
    public void init() {
        desertPyramidAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.desert_pyramid, desertPyramidNormal));
        endCityAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.endcity, endCityNormal));
        iglooAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.igloo, iglooNormal));
        jungleTempleAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.jungle_pyramid, jungleTempleNormal));
        mineshaftAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.mineshaft, mineshaftNormal));
        netherFortressAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.fortress, netherFortressNormal));
        oceanMonumentAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.monument, oceanMonumentNormal));
        oceanRuinAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.ocean_ruin, oceanRuinNormal));
        pillagerOutpostAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.pillager_outpost, pillagerOutpostNormal));
        shipwreckAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.shipwreck, shipwreckNormal));
        strongholdAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.stronghold, strongholdNormal));
        swampHutAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.swamp_hut, swampHutNormal));
        villageAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.village, villageNormal));
        woodlandMansionAdded.forEach(e -> this.configure((String)e, WorldHelper.Structure.mansion, woodlandMansionNormal));
    }

    @SubscribeEvent
    public void onPotentialSpawns(WorldEvent.PotentialSpawns event) {
        if (event.getType() != EntityClassification.MONSTER) {
            return;
        }
        entries.keySet().forEach(structure -> {
            Structure featureStructure = (Structure)Feature.field_202300_at.get((Object)structure.func_176610_l());
            if (featureStructure == null) {
                return;
            }
            this.addSpawnListEntry(event.getWorld(), event.getPos(), event.getList(), (WorldHelper.Structure)structure, (Structure<?>)featureStructure);
        });
    }

    private void configure(String entry, WorldHelper.Structure structure, boolean doNormal) {
        ResourceLocation name;
        int weight = 100;
        if (entry.isEmpty()) {
            return;
        }
        if (entry.contains("=")) {
            String[] split = entry.split("=");
            name = new ResourceLocation(split[0]);
            weight = Integer.parseInt(split[1]);
        } else {
            name = new ResourceLocation(entry);
        }
        Optional type = Registry.field_212629_r.func_218349_b(name);
        if (type.isPresent()) {
            if (!entries.containsKey(structure)) {
                entries.put(structure, new ArrayList());
            }
            entries.get(structure).add(new Biome.SpawnListEntry((EntityType)type.get(), weight, 1, 1));
            normalSpawns.put(structure, doNormal);
        }
    }

    private void addSpawnListEntry(IWorld world, BlockPos pos, List<Biome.SpawnListEntry> list, WorldHelper.Structure structure, Structure<?> featureStructure) {
        if (featureStructure.func_202366_b(world, pos)) {
            if (!normalSpawns.get(structure).booleanValue()) {
                list.clear();
            }
            list.addAll((Collection<Biome.SpawnListEntry>)entries.get(structure));
        }
    }
}

