/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson;

import com.google.common.base.CaseFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import svenhjol.meson.MesonInstance;
import svenhjol.meson.compat.IQuarkCompat;
import svenhjol.meson.compat.QuarkCompat;
import svenhjol.meson.handler.LogHandler;
import svenhjol.meson.handler.PlayerQueueHandler;
import svenhjol.meson.helper.ForgeHelper;
import svenhjol.meson.loader.condition.ModuleEnabledCondition;

public class Meson {
    public static boolean DEBUG = false;
    public static final String MOD_ID = "Meson";
    public static final Meson INSTANCE = new Meson();
    public static final LogHandler LOG = new LogHandler("Meson");
    public static final Marker INTERNAL = MarkerManager.getMarker((String)"INTERNAL");
    public static Map<String, MesonInstance> instances = new ConcurrentHashMap<String, MesonInstance>();
    private IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
    private IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
    private static IQuarkCompat quarkCompat = null;

    private Meson() {
        ModuleEnabledCondition.Serializer modEnabledCondition = new ModuleEnabledCondition.Serializer();
        CraftingHelper.register((IConditionSerializer)modEnabledCondition);
        this.forgeEventBus.register((Object)new PlayerQueueHandler());
    }

    public void register(MesonInstance instance) {
        instances.put(instance.getId(), instance);
        LOG.info("Added " + instance.getId() + " to Meson");
        if (DEBUG) {
            LOG.warn("=== MESON RUNNING IN DEBUG MODE ===");
            LOG.warn("This build of " + instance.getId() + " is designed for testing purposes.");
            LOG.warn("Expect a lot of console output, some of which may be scary.");
            LOG.warn("===================================\n");
        }
        this.modEventBus.addListener(this::onCommonSetup);
        this.modEventBus.addListener(instance::onCommonSetup);
        this.modEventBus.addListener(instance::onModConfig);
        this.modEventBus.addListener(instance::onLoadComplete);
        this.forgeEventBus.addListener(instance::onServerAboutToStart);
        this.forgeEventBus.addListener(instance::onServerStarting);
        this.forgeEventBus.addListener(instance::onServerStarted);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.modEventBus.addListener(instance::onClientSetup));
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        try {
            if (quarkCompat == null && ForgeHelper.isModLoaded("quark")) {
                quarkCompat = (IQuarkCompat)QuarkCompat.class.newInstance();
                quarkCompat.onCommonSetup(event, this.forgeEventBus);
                LOG.debug("Finished Quark compatibility");
            }
        }
        catch (Exception e) {
            LOG.error("Error loading QuarkModules");
        }
    }

    public static MesonInstance getInstance(String modId) {
        if (instances.containsKey(modId)) {
            return instances.get(modId);
        }
        throw new RuntimeException("No such instance " + modId);
    }

    public static boolean isModuleEnabled(String res) {
        return Meson.isModuleEnabled(new ResourceLocation(res));
    }

    public static boolean isModuleEnabled(ResourceLocation res) {
        String inst = res.func_110624_b();
        String mod = res.func_110623_a();
        if (inst.equals("quark") && quarkCompat != null) {
            return quarkCompat.isModuleEnabled(mod);
        }
        if (instances.containsKey(inst)) {
            MesonInstance instance = instances.get(inst);
            if (mod.contains("_")) {
                mod = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, mod);
            }
            return instance.isModuleEnabled(mod);
        }
        return false;
    }
}

