/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonModule;
import svenhjol.meson.handler.LogHandler;
import svenhjol.meson.handler.PacketHandler;
import svenhjol.meson.loader.ModuleLoader;

public class MesonInstance {
    public LogHandler log;
    private String id;
    private ModuleLoader moduleLoader;
    private PacketHandler packetHandler;
    public ArrayListMultimap<Class<?>, Supplier<IForgeRegistryEntry<?>>> registerQueue = ArrayListMultimap.create();

    public MesonInstance(String id, LogHandler log) {
        this.id = id;
        this.log = log;
        Meson.INSTANCE.register(this);
        this.moduleLoader = new ModuleLoader(this);
        this.packetHandler = new PacketHandler(this);
        try {
            this.forEachModule(MesonModule::init);
            this.moduleLoader.refreshConfig();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException("Failed to initialize modules: " + e.getMessage());
        }
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.forEachModule(MesonModule::initClient));
    }

    public static ModuleLoader getModuleLoader(String modId) {
        return Meson.getInstance(modId).getModuleLoader();
    }

    public static PacketHandler getPacketHandler(String modId) {
        return Meson.getInstance(modId).getPacketHandler();
    }

    public String getId() {
        return this.id;
    }

    public PacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        this.moduleLoader.refreshConfig();
        this.moduleLoader.refreshShouldRunSetup();
        this.forEachEnabledModule(module -> {
            this.log.info("Loading module " + module.getName());
            if (module.hasSubscriptions) {
                MinecraftForge.EVENT_BUS.register(module);
            }
            module.onCommonSetup(event);
        });
    }

    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        this.forEachEnabledModule(module -> module.onServerAboutToStart(event));
    }

    public void onServerStarting(FMLServerStartingEvent event) {
        this.forEachEnabledModule(module -> module.onServerStarting(event));
    }

    public void onServerStarted(FMLServerStartedEvent event) {
        this.forEachEnabledModule(module -> module.onServerStarted(event));
    }

    public void onModConfig(ModConfig.ModConfigEvent event) {
        this.moduleLoader.refreshShouldRunSetup();
        this.forEachEnabledModule(module -> module.onModConfig(event));
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        this.forEachEnabledModule(module -> module.onClientSetup(event));
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        this.forEachEnabledModule(module -> module.onLoadComplete(event));
    }

    public void forEachModule(Consumer<MesonModule> consumer) {
        List<MesonModule> modules = this.moduleLoader.getModules();
        modules.forEach(consumer);
    }

    public void forEachEnabledModule(Consumer<MesonModule> consumer) {
        List<MesonModule> enabledModules = this.moduleLoader.getEnabledModules();
        enabledModules.forEach(consumer);
    }

    public boolean isModuleEnabled(String module) {
        return this.moduleLoader.isModuleEnabled(module);
    }
}

