/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentsHelper {
    public static List<Enchantment> getItemCurses(ItemStack item) {
        ListNBT tags = item.func_77986_q();
        ArrayList<Enchantment> curses = new ArrayList<Enchantment>();
        if (!tags.isEmpty()) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)item);
            for (Map.Entry entry : enchants.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                if (enchantment == null || !enchantment.func_190936_d()) continue;
                curses.add(enchantment);
            }
        }
        return curses;
    }

    public static List<Enchantment> getAllCurses() {
        ArrayList<Enchantment> curses = new ArrayList<Enchantment>();
        ForgeRegistries.ENCHANTMENTS.getValues().forEach(enchantment -> {
            if (enchantment.func_190936_d()) {
                curses.add((Enchantment)enchantment);
            }
        });
        return curses;
    }

    public static boolean hasEnchantment(Enchantment enchantment, ItemStack stack) {
        if (stack.func_77973_b() instanceof EnchantedBookItem) {
            return EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(enchantment);
        }
        return EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack) > 0;
    }

    public static void removeEnchantment(Enchantment enchantment, ItemStack stack) {
        if (EnchantmentsHelper.hasEnchantment(enchantment, stack)) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchants.remove(enchantment);
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
        }
    }

    public static void removeRandomCurse(ItemStack stack) {
        List<Enchantment> curses = EnchantmentsHelper.getItemCurses(stack);
        if (curses.size() > 0) {
            Enchantment curseToRemove = curses.get(new Random().nextInt(curses.size()));
            EnchantmentsHelper.removeEnchantment(curseToRemove, stack);
        }
    }
}

