/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.helper;

import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import svenhjol.meson.iface.IMesonEnum;

public class WorldHelper {
    public static final String END_CITY = "EndCity";

    public static BlockRayTraceResult getBlockLookedAt(PlayerEntity player) {
        return WorldHelper.getBlockLookedAt(player, 10);
    }

    public static BlockRayTraceResult getBlockLookedAt(PlayerEntity player, int distance) {
        Vec3d vec3d = player.func_174824_e(1.0f);
        Vec3d vec3d1 = player.func_70676_i(1.0f);
        return player.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d.func_72441_c(vec3d1.field_72450_a * (double)distance, vec3d1.field_72448_b * (double)distance, vec3d1.field_72449_c * (double)distance), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
    }

    public static boolean canSeeSky(IWorld world, BlockPos pos) {
        return world.func_226660_f_(pos);
    }

    public static double getDistanceSq(BlockPos pos1, BlockPos pos2) {
        double d0 = pos1.func_177958_n();
        double d1 = pos1.func_177952_p();
        double d2 = d0 - (double)pos2.func_177958_n();
        double d3 = d1 - (double)pos2.func_177952_p();
        return d2 * d2 + d3 * d3;
    }

    public static int getDimensionId(World world) {
        return world.field_73011_w.func_186058_p().func_186068_a();
    }

    public static void clearWeather(World world) {
        world.func_72912_H().func_176142_i(world.field_73012_v.nextInt(12000) + 3600);
        world.func_72912_H().func_76080_g(0);
        world.func_72912_H().func_76090_f(0);
        world.func_72912_H().func_76069_a(false);
        world.func_72912_H().func_76084_b(false);
    }

    public static void stormyWeather(World world) {
        world.func_72912_H().func_176142_i(0);
        world.func_72912_H().func_76080_g(world.field_73012_v.nextInt(12000) + 3600);
        world.func_72912_H().func_76084_b(true);
        world.func_72912_H().func_76090_f(world.field_73012_v.nextInt(12000) + 7200);
        world.func_72912_H().func_76069_a(true);
    }

    public static boolean isSolidBlock(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_200132_m() && !world.func_175623_d(pos) && !state.func_185904_a().func_76224_d();
    }

    public static boolean isSolidishBlock(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return WorldHelper.isSolidBlock(world, pos) || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151597_y || state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151585_k;
    }

    public static boolean isAirBlock(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return !state.func_200132_m() || state.func_185904_a() == Material.field_151586_h || state.func_185904_a() == Material.field_151597_y || state.func_185904_a() == Material.field_151586_h || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151577_b;
    }

    public static enum Structure implements IMesonEnum
    {
        buried_treasure,
        desert_pyramid,
        endcity,
        igloo,
        jungle_pyramid,
        mansion,
        mineshaft,
        fortress,
        monument,
        ocean_ruin,
        pillager_outpost,
        shipwreck,
        stronghold,
        swamp_hut,
        village;

    }
}

