/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.iface.Config;

public class ConfigHandler {
    public static void createConfig(String mod, Map<String, CharmModule> modules) {
        LinkedHashMap finalConfig = new LinkedHashMap();
        String configName = mod.equals("charm") ? "charm" : "charm-" + mod;
        String configPath = "./config/" + configName + ".json";
        modules.forEach((moduleName, module) -> {
            finalConfig.put(moduleName, new LinkedHashMap());
            ((Map)finalConfig.get(moduleName)).put("Description", module.description);
            if (!module.alwaysEnabled) {
                ((Map)finalConfig.get(moduleName)).put("Enabled", module.enabled);
            }
        });
        try {
            Map<?, ?> loadedConfig = ConfigHandler.readConfig(Paths.get(configPath, new String[0]));
            for (Map.Entry<?, ?> entry : loadedConfig.entrySet()) {
                String moduleName2;
                Object key = entry.getKey();
                if (!(key instanceof String) || !finalConfig.containsKey(moduleName2 = (String)key)) continue;
                LinkedTreeMap entriesFromConfig = (LinkedTreeMap)entry.getValue();
                entriesFromConfig.remove((Object)"Description");
                ((Map)finalConfig.get(moduleName2)).putAll(entriesFromConfig);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read config for " + configName, e);
        }
        for (Map.Entry<String, CharmModule> entry : modules.entrySet()) {
            String moduleName3 = entry.getKey();
            CharmModule module2 = entry.getValue();
            module2.enabled = ((Map)finalConfig.get(moduleName3)).getOrDefault("Enabled", module2.enabledByDefault);
            ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(module2.getClass().getDeclaredFields()));
            fields.forEach(field -> {
                try {
                    Config annotation = field.getDeclaredAnnotation(Config.class);
                    if (annotation == null) {
                        return;
                    }
                    field.setAccessible(true);
                    String name = annotation.name();
                    if (name.isEmpty()) {
                        name = field.getName();
                    }
                    Object val = field.get(null);
                    if (((Map)finalConfig.get(moduleName3)).containsKey(name)) {
                        Object configVal = ((Map)finalConfig.get(moduleName3)).get(name);
                        if (val instanceof Integer && configVal instanceof Double) {
                            configVal = (int)((Double)configVal).doubleValue();
                        }
                        field.set(null, configVal);
                        ((Map)finalConfig.get(moduleName3)).put(name, configVal);
                    } else {
                        ((Map)finalConfig.get(moduleName3)).put(name, val);
                    }
                }
                catch (Exception e) {
                    Charm.LOG.error("Failed to set config for " + moduleName3 + ": " + e.getMessage());
                }
            });
        }
        try {
            ConfigHandler.writeConfig(Paths.get(configPath, new String[0]), finalConfig);
        }
        catch (Exception e) {
            Charm.LOG.error("Failed to write config: " + e.getMessage());
        }
    }

    private static Map<?, ?> readConfig(Path path) throws IOException {
        ConfigHandler.touch(path);
        Gson gson = new Gson();
        BufferedReader reader = Files.newBufferedReader(path);
        Map map = (Map)gson.fromJson((Reader)reader, Map.class);
        ((Reader)reader).close();
        return map;
    }

    private static void writeConfig(Path path, Map<?, ?> map) throws IOException {
        ConfigHandler.touch(path);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
        gson.toJson(map, (Appendable)writer);
        ((Writer)writer).close();
    }

    private static void touch(Path path) throws IOException {
        File file = path.toFile();
        if (file.exists()) {
            return;
        }
        File dir = file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Could not create config parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("Parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write("{}");
        }
    }
}

