/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.BiomeHandler;
import svenhjol.charm.base.handler.ConfigHandler;
import svenhjol.charm.base.handler.DecorationHandler;
import svenhjol.charm.base.helper.StringHelper;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.event.ClientJoinCallback;
import svenhjol.charm.event.LoadWorldCallback;
import svenhjol.charm.event.StructureSetupCallback;
import svenhjol.charm.handler.ColoredGlintHandler;

public class ModuleHandler {
    public static Map<String, List<Class<? extends CharmModule>>> AVAILABLE_MODULES = new HashMap<String, List<Class<? extends CharmModule>>>();
    public static Map<String, CharmModule> LOADED_MODULES = new ConcurrentHashMap<String, CharmModule>();
    private static boolean hasInit = false;

    public static void init() {
        if (hasInit) {
            return;
        }
        ModuleHandler.instantiateModules();
        BiomeHandler.init();
        ModuleHandler.eachModule(CharmModule::register);
        if (ModuleHandler.isClient()) {
            ModuleHandler.eachModule(CharmModule::clientRegister);
        }
        ModuleHandler.eachEnabledModule(CharmModule::init);
        if (ModuleHandler.isClient()) {
            ModuleHandler.eachEnabledModule(CharmModule::clientInit);
        }
        ((StructureSetupCallback)StructureSetupCallback.EVENT.invoker()).interact();
        LoadWorldCallback.EVENT.register(server -> {
            DecorationHandler.init();
            ModuleHandler.eachEnabledModule(m -> m.loadWorld(server));
        });
        if (ModuleHandler.isClient()) {
            ClientJoinCallback.EVENT.register(client -> {
                ColoredGlintHandler.init();
                DecorationHandler.init();
                ModuleHandler.eachEnabledModule(m -> m.clientJoinWorld(client));
            });
        }
        hasInit = true;
    }

    @Nullable
    public static CharmModule getModule(String moduleName) {
        return LOADED_MODULES.getOrDefault(StringHelper.snakeToUpperCamel(moduleName), null);
    }

    public static Map<String, CharmModule> getLoadedModules() {
        return LOADED_MODULES;
    }

    public static boolean enabled(String moduleName) {
        String[] split = moduleName.split(":");
        String modName = split[0];
        String modModule = split[1];
        CharmModule module = ModuleHandler.getModule(modModule);
        return module != null && module.enabled;
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    private static void instantiateModules() {
        AVAILABLE_MODULES.forEach((mod, modules) -> {
            TreeMap<String, CharmModule> loaded = new TreeMap<String, CharmModule>();
            modules.forEach(clazz -> {
                try {
                    Module annotation;
                    CharmModule module = (CharmModule)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (clazz.isAnnotationPresent(Module.class)) {
                        annotation = clazz.getAnnotation(Module.class);
                        if (annotation.mod().isEmpty()) {
                            throw new Exception("mod name must be defined");
                        }
                    } else {
                        throw new RuntimeException("No module annotation for class " + clazz.toString());
                    }
                    module.mod = annotation.mod();
                    module.alwaysEnabled = annotation.alwaysEnabled();
                    module.enabled = module.enabledByDefault = annotation.enabledByDefault();
                    module.description = annotation.description();
                    String moduleName = module.getName();
                    loaded.put(moduleName, module);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not initialize module class: " + clazz.toString(), e);
                }
            });
            ConfigHandler.createConfig(mod, loaded);
            loaded.forEach((moduleName, module) -> LOADED_MODULES.put((String)moduleName, (CharmModule)module));
        });
    }

    private static void eachModule(Consumer<CharmModule> consumer) {
        LOADED_MODULES.values().forEach(consumer);
    }

    private static void eachEnabledModule(Consumer<CharmModule> consumer) {
        LOADED_MODULES.values().stream().filter(m -> m.enabled).forEach(consumer);
    }
}

