/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.helper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_4543;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import svenhjol.charm.mixin.accessor.GenerationSettingsAccessor;
import svenhjol.charm.mixin.accessor.SpawnSettingsAccessor;

public class BiomeHelper {
    public static List<String> BADLANDS = new ArrayList<String>();
    public static List<String> DESERT = new ArrayList<String>();
    public static List<String> END = new ArrayList<String>();
    public static List<String> FOREST = new ArrayList<String>();
    public static List<String> JUNGLE = new ArrayList<String>();
    public static List<String> MOUNTAINS = new ArrayList<String>();
    public static List<String> NETHER = new ArrayList<String>();
    public static List<String> PLAINS = new ArrayList<String>();
    public static List<String> SAVANNA = new ArrayList<String>();
    public static List<String> SNOWY = new ArrayList<String>();
    public static List<String> TAIGA = new ArrayList<String>();

    public static class_1959 getBiome(class_3218 world, class_2338 pos) {
        class_4543 biomeAccess = world.method_22385();
        return biomeAccess.method_22393(pos);
    }

    public static class_1959 getBiomeFromBiomeKey(class_5321<class_1959> biomeKey) {
        return (class_1959)class_5458.field_25933.method_29107(biomeKey);
    }

    public static Optional<class_5321<class_1959>> getBiomeKeyAtPosition(class_3218 world, class_2338 pos) {
        return world.method_31081(pos);
    }

    public static class_2338 locateBiome(class_5321<class_1959> biomeKey, class_3218 world, class_2338 pos) {
        class_1959 biome = (class_1959)world.method_30349().method_30530(class_2378.field_25114).method_29107(biomeKey);
        return BiomeHelper.locateBiome(biome, world, pos);
    }

    public static class_2338 locateBiome(class_1959 biome, class_3218 world, class_2338 pos) {
        return world.method_24500(biome, pos, 6400, 8);
    }

    public static void addStructureFeature(class_1959 biome, class_5312<?, ?> structureFeature) {
        class_5485 settings = biome.method_30970();
        BiomeHelper.checkGenerationSettingsMutable(settings);
        ((GenerationSettingsAccessor)settings).getStructureFeatures().add(() -> structureFeature);
    }

    public static void addSpawnEntry(class_1959 biome, class_1311 group, class_1299<?> entity, int weight, int minGroupSize, int maxGroupSize) {
        class_5483 settings = biome.method_30966();
        BiomeHelper.checkSpawnSettingsMutable(settings);
        Map<class_1311, List<class_5483.class_1964>> spawners = ((SpawnSettingsAccessor)settings).getSpawners();
        spawners.get(group).add(new class_5483.class_1964(entity, weight, minGroupSize, maxGroupSize));
        ((SpawnSettingsAccessor)settings).setSpawners(spawners);
    }

    private static void checkGenerationSettingsMutable(class_5485 settings) {
        List<Supplier<class_5312<?, ?>>> existing = ((GenerationSettingsAccessor)settings).getStructureFeatures();
        if (existing instanceof ImmutableList) {
            ((GenerationSettingsAccessor)settings).setStructureFeatures(new ArrayList(existing));
        }
    }

    private static void checkSpawnSettingsMutable(class_5483 settings) {
        Map<class_1311, List<class_5483.class_1964>> spawners = ((SpawnSettingsAccessor)settings).getSpawners();
        Map<class_1299<?>, class_5483.class_5265> spawnCosts = ((SpawnSettingsAccessor)settings).getSpawnCosts();
        if (spawners instanceof ImmutableMap) {
            HashMap<class_1311, List<class_5483.class_1964>> mutable = new HashMap<class_1311, List<class_5483.class_1964>>(spawners);
            spawners.forEach((spawnGroup, spawnEntries) -> mutable.put((class_1311)spawnGroup, new ArrayList(spawnEntries)));
            ((SpawnSettingsAccessor)settings).setSpawners(new HashMap<class_1311, List<class_5483.class_1964>>(mutable));
        }
        if (spawnCosts instanceof ImmutableMap) {
            ((SpawnSettingsAccessor)settings).setSpawnCosts(new HashMap(spawnCosts));
        }
    }
}

