/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2621;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2776;
import net.minecraft.class_2960;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3708;
import net.minecraft.class_3749;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import svenhjol.charm.base.enums.IVariantMaterial;
import svenhjol.charm.base.enums.VanillaVariantMaterial;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.helper.DataBlockHelper;
import svenhjol.charm.base.helper.DecorationHelper;
import svenhjol.charm.block.BookcaseBlock;
import svenhjol.charm.blockentity.BookcaseBlockEntity;
import svenhjol.charm.blockentity.EntitySpawnerBlockEntity;
import svenhjol.charm.module.Bookcases;
import svenhjol.charm.module.Crates;
import svenhjol.charm.module.EntitySpawner;
import svenhjol.charm.module.GoldLanterns;
import svenhjol.charm.module.VariantBarrels;
import svenhjol.charm.module.VariantBookshelves;
import svenhjol.charm.module.VariantChests;

public class DataBlockProcessor
extends class_3491 {
    public DataBlockResolver resolver = new DataBlockResolver();
    public static Map<String, Consumer<DataBlockResolver>> callbacks = new HashMap<String, Consumer<DataBlockResolver>>();

    @Nullable
    public class_3499.class_3501 method_15110(class_4538 world, class_2338 pos, class_2338 blockPos, class_3499.class_3501 unused, class_3499.class_3501 blockInfo, class_3492 placement) {
        class_2776 mode;
        if (blockInfo.field_15596.method_26204() == class_2246.field_10465 && (mode = class_2776.valueOf((String)blockInfo.field_15595.method_10558("mode"))) == class_2776.field_12696) {
            return this.resolver.replace(world, placement.method_15113(), blockInfo, new Random(pos.method_10063()));
        }
        return blockInfo;
    }

    protected class_3828<?> method_16772() {
        return null;
    }

    public static class DataBlockResolver {
        private static final String ANVIL = "anvil";
        private static final String ARMOR = "armor";
        private static final String BLOCK = "block";
        private static final String BOOKSHELF = "bookshelf";
        private static final String CARPET = "carpet";
        private static final String CAULDRON = "cauldron";
        private static final String CHEST = "chest";
        private static final String DECORATION = "decoration";
        private static final String ENTITY = "entity";
        private static final String FLOWER = "flower";
        private static final String LANTERN = "lantern";
        private static final String LAVA = "lava";
        private static final String MOB = "mob";
        private static final String ORE = "ore";
        private static final String FLOWERPOT = "plantpot";
        private static final String SAPLING = "sapling";
        private static final String SPAWNER = "spawner";
        private static final String STORAGE = "storage";
        public static float BLOCK_CHANCE = 0.8f;
        public static float BOOKCASE_CHANCE = 0.15f;
        public static float BOOKCASE_LOOT_CHANCE = 0.4f;
        public static float CHEST_CHANCE = 0.66f;
        public static float DECORATION_CHANCE = 0.85f;
        public static float FLOWER_CHANCE = 0.8f;
        public static float FLOWERPOT_CHANCE = 0.8f;
        public static float LANTERN_CHANCE = 0.9f;
        public static float LANTERN_GOLD_CHANCE = 0.25f;
        public static float LAVA_CHANCE = 0.7f;
        public static float MOB_CHANCE = 0.75f;
        public static float ORE_CHANCE = 0.75f;
        public static float RARE_ORE_CHANCE = 0.25f;
        public static float RARE_CHEST_CHANCE = 0.1f;
        public static float RUBBLE_CHANCE = 0.9f;
        public static float RUNESTONE_CHANCE = 0.75f;
        public static float SAPLING_CHANCE = 0.8f;
        public static float SPAWNER_CHANCE = 0.8f;
        public static float STORAGE_CHANCE = 0.7f;
        public String data;
        public class_2470 rotation;
        public class_2680 state;
        public class_2338 pos;
        public class_4538 world;
        public class_2487 tag;
        public Random fixedRandom;
        public Random random;
        public float chance;

        public class_3499.class_3501 replace(class_4538 world, class_2470 rotation, class_3499.class_3501 blockInfo, Random random) {
            String data = blockInfo.field_15595.method_10558("metadata");
            this.world = world;
            this.fixedRandom = random;
            this.rotation = rotation;
            this.pos = blockInfo.field_15597;
            this.state = null;
            this.tag = null;
            this.random = new Random(blockInfo.hashCode());
            if (data.contains("|")) {
                String[] split = data.split("\\|");
                data = split[this.random.nextInt(split.length)];
            }
            this.data = data.trim();
            this.chance = this.getChance(this.data, 0.0f);
            if (this.data.startsWith(ANVIL)) {
                this.anvil();
            }
            if (this.data.startsWith(ARMOR)) {
                this.armorStand();
            }
            if (this.data.startsWith(BLOCK)) {
                this.block();
            }
            if (this.data.startsWith(BOOKSHELF)) {
                this.bookshelf();
            }
            if (this.data.startsWith(CARPET)) {
                this.carpet();
            }
            if (this.data.startsWith(CAULDRON)) {
                this.cauldron();
            }
            if (this.data.startsWith(CHEST)) {
                this.chest();
            }
            if (this.data.startsWith(DECORATION)) {
                this.decoration();
            }
            if (this.data.startsWith(ENTITY)) {
                this.entity();
            }
            if (this.data.startsWith(FLOWER)) {
                this.flower();
            }
            if (this.data.startsWith(FLOWERPOT)) {
                this.flowerpot();
            }
            if (this.data.startsWith(LANTERN)) {
                this.lantern();
            }
            if (this.data.startsWith(LAVA)) {
                this.lava();
            }
            if (this.data.startsWith(MOB)) {
                this.mob();
            }
            if (this.data.startsWith(ORE)) {
                this.ore();
            }
            if (this.data.startsWith(SAPLING)) {
                this.sapling();
            }
            if (this.data.startsWith(SPAWNER)) {
                this.spawner();
            }
            if (this.data.startsWith(STORAGE)) {
                this.storage();
            }
            if (this.state == null) {
                callbacks.entrySet().stream().filter(entry -> this.data.startsWith((String)entry.getKey())).forEach(entry -> ((Consumer)entry.getValue()).accept(this));
                if (this.state == null) {
                    this.state = class_2246.field_10124.method_9564();
                }
            }
            return new class_3499.class_3501(this.pos, this.state, this.tag);
        }

        protected void anvil() {
            float f = this.random.nextFloat();
            if (f < 0.33f) {
                this.state = class_2246.field_10535.method_9564();
            } else if (f < 0.66f) {
                this.state = class_2246.field_10105.method_9564();
            } else if (f < 1.0f) {
                this.state = class_2246.field_10414.method_9564();
            }
        }

        protected void armorStand() {
            EntitySpawnerBlockEntity blockEntity = (EntitySpawnerBlockEntity)EntitySpawner.BLOCK_ENTITY.method_11032();
            if (blockEntity == null) {
                return;
            }
            this.tag = new class_2487();
            blockEntity.entity = new class_2960("minecraft:armor_stand");
            blockEntity.meta = this.data;
            blockEntity.rotation = this.rotation;
            blockEntity.method_11007(this.tag);
            this.state = EntitySpawner.ENTITY_SPAWNER.method_9564();
        }

        protected void block() {
            if (!this.withChance(BLOCK_CHANCE)) {
                return;
            }
            String type = DataBlockHelper.getValue("type", this.data, "");
            if (type.isEmpty()) {
                return;
            }
            class_2960 typeId = new class_2960(type);
            Optional optionalBlock = class_2378.field_11146.method_17966(typeId);
            if (!optionalBlock.isPresent()) {
                return;
            }
            class_2248 block = (class_2248)optionalBlock.get();
            this.state = block.method_9564();
        }

        protected void bookshelf() {
            IVariantMaterial variantMaterial = DecorationHelper.getRandomVariantMaterial(this.fixedRandom);
            if (ModuleHandler.enabled("charm:bookcases") && this.withChance(BOOKCASE_CHANCE)) {
                this.state = (class_2680)Bookcases.BOOKCASE_BLOCKS.get(variantMaterial).method_9564().method_11657((class_2769)BookcaseBlock.SLOTS, (Comparable)Integer.valueOf(BookcaseBlockEntity.SIZE));
                if (this.random.nextFloat() < BOOKCASE_LOOT_CHANCE) {
                    BookcaseBlockEntity blockEntity = (BookcaseBlockEntity)Bookcases.BLOCK_ENTITY.method_11032();
                    if (blockEntity == null) {
                        return;
                    }
                    blockEntity.method_11285(DecorationHelper.getRandomLootTable(DecorationHelper.BOOKCASE_LOOT_TABLES, this.random), this.random.nextLong());
                    this.tag = new class_2487();
                    blockEntity.method_11007(this.tag);
                }
            } else {
                this.state = ModuleHandler.enabled("charm:variant_bookshelves") && variantMaterial != VanillaVariantMaterial.OAK ? VariantBookshelves.BOOKSHELF_BLOCKS.get(variantMaterial).method_9564() : class_2246.field_10504.method_9564();
            }
        }

        protected void carpet() {
            ArrayList<class_2248> types = new ArrayList<class_2248>(DecorationHelper.CARPETS);
            Collections.shuffle(types, this.fixedRandom);
            int type = DataBlockHelper.getValue("type", this.data, 0);
            if (type > types.size()) {
                type = 0;
            }
            this.state = ((class_2248)types.get(type)).method_9564();
        }

        protected void cauldron() {
            this.state = (class_2680)class_2246.field_10593.method_9564().method_11657((class_2769)class_2275.field_10745, (Comparable)Integer.valueOf((int)Math.max(3.0f, 4.0f * this.random.nextFloat())));
        }

        protected void chest() {
            if (!this.withChance(CHEST_CHANCE)) {
                return;
            }
            if (ModuleHandler.enabled("charm:variant_chests")) {
                IVariantMaterial variantMaterial = DecorationHelper.getRandomVariantMaterial(this.random);
                this.state = this.random.nextFloat() < 0.1f ? VariantChests.TRAPPED_CHEST_BLOCKS.get(variantMaterial).method_9564() : VariantChests.NORMAL_CHEST_BLOCKS.get(variantMaterial).method_9564();
            } else {
                this.state = class_2246.field_10034.method_9564();
            }
            this.state = DataBlockHelper.setFacing(this.state, class_2281.field_10768, DataBlockHelper.getValue("facing", this.data, "north"));
            class_2960 lootTable = DecorationHelper.getRandomLootTable(this.random.nextFloat() < RARE_CHEST_CHANCE ? DecorationHelper.RARE_CHEST_LOOT_TABLES : DecorationHelper.CHEST_LOOT_TABLES, this.random);
            class_2595 blockEntity = (class_2595)class_2591.field_11914.method_11032();
            if (blockEntity == null) {
                return;
            }
            blockEntity.method_11285(DataBlockHelper.getLootTable(this.data, lootTable), this.random.nextLong());
            this.tag = new class_2487();
            blockEntity.method_11007(this.tag);
        }

        protected void decoration() {
            if (!this.withChance(DECORATION_CHANCE)) {
                return;
            }
            class_2350 facing = DataBlockHelper.getFacing(DataBlockHelper.getValue("facing", this.data, "north"));
            this.state = DecorationHelper.getRandomBlock(DecorationHelper.DECORATION_BLOCKS, this.random, facing);
        }

        protected void entity() {
            EntitySpawnerBlockEntity blockEntity = (EntitySpawnerBlockEntity)EntitySpawner.BLOCK_ENTITY.method_11032();
            if (blockEntity == null) {
                return;
            }
            this.tag = new class_2487();
            String type = DataBlockHelper.getValue("type", this.data, "");
            if (type.isEmpty()) {
                return;
            }
            class_2960 typeId = new class_2960(type);
            if (!class_2378.field_11145.method_17966(typeId).isPresent()) {
                return;
            }
            blockEntity.entity = typeId;
            blockEntity.meta = this.data;
            blockEntity.rotation = this.rotation;
            blockEntity.method_11007(this.tag);
            this.state = EntitySpawner.ENTITY_SPAWNER.method_9564();
        }

        protected void flower() {
            if (!this.withChance(FLOWER_CHANCE)) {
                return;
            }
            this.state = DecorationHelper.getRandomBlock(DecorationHelper.FLOWERS, this.random);
        }

        protected void flowerpot() {
            if (!this.withChance(FLOWERPOT_CHANCE)) {
                return;
            }
            this.state = DecorationHelper.getRandomBlock(DecorationHelper.FLOWER_POTS, this.random);
        }

        protected void lantern() {
            if (!this.withChance(LANTERN_CHANCE)) {
                return;
            }
            this.state = class_2246.field_16541.method_9564();
            if (ModuleHandler.enabled("charm:gold_lanterns") && this.random.nextFloat() < LANTERN_GOLD_CHANCE) {
                this.state = GoldLanterns.GOLD_LANTERN.method_9564();
            }
            if (this.data.contains("hanging")) {
                this.state = (class_2680)this.state.method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true));
            }
        }

        protected void lava() {
            this.state = class_2246.field_10092.method_9564();
            if (this.fixedRandom.nextFloat() < LAVA_CHANCE) {
                this.state = class_2246.field_10164.method_9564();
            }
        }

        protected void mob() {
            if (!this.withChance(MOB_CHANCE)) {
                return;
            }
            EntitySpawnerBlockEntity blockEntity = (EntitySpawnerBlockEntity)EntitySpawner.BLOCK_ENTITY.method_11032();
            if (blockEntity == null) {
                return;
            }
            String type = DataBlockHelper.getValue("type", this.data, "");
            if (type.isEmpty()) {
                return;
            }
            this.tag = new class_2487();
            blockEntity.entity = new class_2960(type);
            blockEntity.health = DataBlockHelper.getValue("health", this.data, 0.0);
            blockEntity.persist = DataBlockHelper.getValue("persist", this.data, true);
            blockEntity.count = DataBlockHelper.getValue("count", this.data, 1);
            blockEntity.rotation = this.rotation;
            blockEntity.method_11007(this.tag);
            this.state = EntitySpawner.ENTITY_SPAWNER.method_9564();
        }

        protected void ore() {
            if (!this.withChance(ORE_CHANCE)) {
                return;
            }
            String type = DataBlockHelper.getValue("type", this.data, "");
            if (!type.isEmpty()) {
                class_2960 typeId = new class_2960(type);
                if (!class_2378.field_11145.method_17966(typeId).isPresent()) {
                    return;
                }
                class_2248 ore = (class_2248)class_2378.field_11146.method_10223(typeId);
                this.state = ore.method_9564();
                return;
            }
            this.state = this.fixedRandom.nextFloat() < RARE_ORE_CHANCE ? DecorationHelper.getRandomBlock(DecorationHelper.RARE_ORES, this.fixedRandom) : DecorationHelper.getRandomBlock(DecorationHelper.COMMON_ORES, this.fixedRandom);
        }

        protected void sapling() {
            if (!this.withChance(SAPLING_CHANCE)) {
                return;
            }
            this.state = DecorationHelper.getRandomBlock(DecorationHelper.SAPLINGS, this.random);
        }

        protected void spawner() {
            class_1299 entity;
            if (!this.withChance(SPAWNER_CHANCE)) {
                return;
            }
            String type = DataBlockHelper.getValue("type", this.data, "");
            if (type.isEmpty()) {
                entity = DecorationHelper.SPAWNER_MOBS.size() > 0 ? DecorationHelper.SPAWNER_MOBS.get(this.random.nextInt(DecorationHelper.SPAWNER_MOBS.size())) : null;
            } else {
                class_2960 typeId = new class_2960(type);
                if (!class_2378.field_11145.method_17966(typeId).isPresent()) {
                    return;
                }
                entity = (class_1299)class_2378.field_11145.method_10223(typeId);
            }
            if (entity == null) {
                return;
            }
            this.state = class_2246.field_10260.method_9564();
            class_2636 blockEntity = (class_2636)class_2591.field_11889.method_11032();
            if (blockEntity != null) {
                blockEntity.method_11390().method_8274(entity);
                this.tag = new class_2487();
                blockEntity.method_11007(this.tag);
            }
        }

        protected void storage() {
            class_2621 blockEntity;
            if (!this.withChance(STORAGE_CHANCE)) {
                return;
            }
            IVariantMaterial woodType = DecorationHelper.getRandomVariantMaterial(this.random);
            if (this.random.nextFloat() < 0.5f && ModuleHandler.enabled("charm:crates")) {
                this.state = Crates.CRATE_BLOCKS.get(woodType).method_9564();
                blockEntity = (class_2621)Crates.BLOCK_ENTITY.method_11032();
            } else {
                this.state = ModuleHandler.enabled("charm:variant_barrels") ? VariantBarrels.BARREL_BLOCKS.get(woodType).method_9564() : class_2246.field_16328.method_9564();
                this.state = (class_2680)this.state.method_11657((class_2769)class_3708.field_16320, (Comparable)class_2350.field_11036);
                blockEntity = (class_2621)class_2591.field_16411.method_11032();
            }
            if (blockEntity == null) {
                return;
            }
            class_2960 lootTable = DecorationHelper.getRandomLootTable(DecorationHelper.COMMON_LOOT_TABLES, this.random);
            blockEntity.method_11285(DataBlockHelper.getLootTable(this.data, lootTable), this.random.nextLong());
            this.tag = new class_2487();
            blockEntity.method_11007(this.tag);
        }

        public boolean withChance(float chance) {
            float f = this.random.nextFloat();
            return this.chance > 0.0f ? f < this.chance : f < chance;
        }

        public float getChance(String data, float fallback) {
            int i = DataBlockHelper.getValue("chance", data, 0);
            return i == 0 ? fallback : (float)i / 100.0f;
        }
    }
}

