/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.blockentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1694;
import net.minecraft.class_1695;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3000;
import net.minecraft.class_3730;
import net.minecraft.class_39;
import net.minecraft.class_5425;
import svenhjol.charm.Charm;
import svenhjol.charm.base.helper.DataBlockHelper;
import svenhjol.charm.module.EntitySpawner;

public class EntitySpawnerBlockEntity
extends class_2586
implements class_3000 {
    private static final String ENTITY = "entity";
    private static final String PERSIST = "persist";
    private static final String HEALTH = "health";
    private static final String META = "meta";
    private static final String COUNT = "count";
    private static final String ROTATION = "rotation";
    public class_2960 entity = null;
    public class_2470 rotation = class_2470.field_11467;
    public boolean persist = false;
    public double health = 0.0;
    public int count = 1;
    public String meta = "";

    public EntitySpawnerBlockEntity() {
        super(EntitySpawner.BLOCK_ENTITY);
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        super.method_11014(state, tag);
        this.entity = class_2960.method_12829((String)tag.method_10558(ENTITY));
        this.persist = tag.method_10577(PERSIST);
        this.health = tag.method_10574(HEALTH);
        this.count = tag.method_10550(COUNT);
        this.meta = tag.method_10558(META);
        String rot = tag.method_10558(ROTATION);
        this.rotation = rot.isEmpty() ? class_2470.field_11467 : class_2470.valueOf((String)rot);
    }

    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10582(ENTITY, this.entity.toString());
        tag.method_10582(ROTATION, this.rotation.name());
        tag.method_10556(PERSIST, this.persist);
        tag.method_10549(HEALTH, this.health);
        tag.method_10569(COUNT, this.count);
        tag.method_10582(META, this.meta);
        return tag;
    }

    public void method_16896() {
        if (this.field_11863 == null || this.field_11863.method_8510() % 10L == 0L || this.field_11863.method_8407() == class_1267.field_5801) {
            return;
        }
        class_2338 pos = this.method_11016();
        List players = this.field_11863.method_18467(class_1657.class, new class_238(pos).method_1014((double)EntitySpawner.triggerDistance));
        if (players.size() == 0) {
            return;
        }
        this.field_11863.method_8652(pos, class_2246.field_10124.method_9564(), 2);
        boolean result = this.trySpawn(pos);
        if (result) {
            Charm.LOG.debug("EntitySpawner spawned entity " + this.entity.toString() + " at pos: " + pos);
        } else {
            Charm.LOG.debug("EntitySpawner failed to spawn entity " + this.entity.toString() + " at pos: " + pos);
        }
    }

    public boolean trySpawn(class_2338 pos) {
        if (this.field_11863 == null) {
            return false;
        }
        Optional optionalEntityType = class_2378.field_11145.method_17966(this.entity);
        if (!optionalEntityType.isPresent()) {
            return false;
        }
        class_1299 type = (class_1299)optionalEntityType.get();
        if (type == class_1299.field_6096 || type == class_1299.field_6126) {
            return this.tryCreateMinecart(type, pos);
        }
        if (type == class_1299.field_6131) {
            return this.tryCreateArmorStand(pos);
        }
        for (int i = 0; i < this.count; ++i) {
            class_1297 spawned = type.method_5883(this.field_11863);
            if (spawned == null) {
                return false;
            }
            spawned.method_5725(pos, 0.0f, 0.0f);
            if (spawned instanceof class_1308) {
                class_1308 m = (class_1308)spawned;
                if (this.persist) {
                    m.method_5971();
                }
                if (this.health > 0.0) {
                    m.method_6033((float)this.health);
                }
                m.method_5943((class_5425)this.field_11863, this.field_11863.method_8404(pos), class_3730.field_16461, null, null);
            }
            this.field_11863.method_8649(spawned);
        }
        return true;
    }

    public boolean tryCreateMinecart(class_1299<?> type, class_2338 pos) {
        class_1694 minecart = null;
        if (this.field_11863 == null) {
            return false;
        }
        if (type == class_1299.field_6126) {
            minecart = new class_1694(this.field_11863, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            class_2960 lootTable = DataBlockHelper.getLootTable(this.meta, class_39.field_472);
            minecart.method_7562(lootTable, this.field_11863.field_9229.nextLong());
        } else if (type == class_1299.field_6096) {
            minecart = new class_1695(this.field_11863, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        }
        if (minecart == null) {
            return false;
        }
        this.field_11863.method_8649(minecart);
        return true;
    }

    public boolean tryCreateArmorStand(class_2338 pos) {
        if (this.field_11863 == null) {
            return false;
        }
        Random random = this.field_11863.field_9229;
        class_1531 stand = (class_1531)class_1299.field_6131.method_5883(this.field_11863);
        if (stand == null) {
            return false;
        }
        class_2350 face = DataBlockHelper.getFacing(DataBlockHelper.getValue("facing", this.meta, "north"));
        class_2350 facing = this.rotation.method_10503(face);
        String type = DataBlockHelper.getValue("type", this.meta, "");
        ArrayList<class_1792> ironHeld = new ArrayList<class_1792>(Arrays.asList(class_1802.field_8371, class_1802.field_8403, class_1802.field_8475));
        ArrayList<class_1792> goldHeld = new ArrayList<class_1792>(Arrays.asList(class_1802.field_8802, class_1802.field_8377));
        ArrayList<class_1792> diamondHeld = new ArrayList<class_1792>(Arrays.asList(class_1802.field_8802, class_1802.field_8377, class_1802.field_8556, class_1802.field_8250));
        if (type.equals("chain")) {
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6173.method_5926(), new class_1799((class_1935)ironHeld.get(random.nextInt(ironHeld.size()))));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6169.method_5926(), new class_1799((class_1935)class_1802.field_8283));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6174.method_5926(), new class_1799((class_1935)class_1802.field_8873));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6172.method_5926(), new class_1799((class_1935)class_1802.field_8218));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6166.method_5926(), new class_1799((class_1935)class_1802.field_8313));
            }
        }
        if (type.equals("iron")) {
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6173.method_5926(), new class_1799((class_1935)ironHeld.get(random.nextInt(ironHeld.size()))));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6169.method_5926(), new class_1799((class_1935)class_1802.field_8743));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6174.method_5926(), new class_1799((class_1935)class_1802.field_8523));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6172.method_5926(), new class_1799((class_1935)class_1802.field_8396));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6166.method_5926(), new class_1799((class_1935)class_1802.field_8660));
            }
        }
        if (type.equals("gold")) {
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6173.method_5926(), new class_1799((class_1935)goldHeld.get(random.nextInt(goldHeld.size()))));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6169.method_5926(), new class_1799((class_1935)class_1802.field_8862));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6174.method_5926(), new class_1799((class_1935)class_1802.field_8678));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6172.method_5926(), new class_1799((class_1935)class_1802.field_8416));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6166.method_5926(), new class_1799((class_1935)class_1802.field_8753));
            }
        }
        if (type.equals("diamond")) {
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6173.method_5926(), new class_1799((class_1935)diamondHeld.get(random.nextInt(diamondHeld.size()))));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6169.method_5926(), new class_1799((class_1935)class_1802.field_8805));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6174.method_5926(), new class_1799((class_1935)class_1802.field_8058));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6172.method_5926(), new class_1799((class_1935)class_1802.field_8348));
            }
            if (random.nextFloat() < 0.25f) {
                stand.method_5758(class_1304.field_6166.method_5926(), new class_1799((class_1935)class_1802.field_8285));
            }
        }
        float yaw = facing.method_10161();
        stand.method_5725(pos, yaw, 0.0f);
        this.field_11863.method_8649((class_1297)stand);
        return true;
    }
}

