/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2387;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5195;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.helper.DimensionHelper;
import svenhjol.charm.base.helper.SoundHelper;
import svenhjol.charm.client.MusicCondition;
import svenhjol.charm.event.PlaySoundCallback;
import svenhjol.charm.module.MusicImprovements;

public class MusicClient {
    private final CharmModule module;
    private class_1113 musicToStop = null;
    private int ticksBeforeStop = 0;
    private static class_1113 currentMusic;
    private static class_2960 currentDim;
    private static int timeUntilNextMusic;
    private static final List<MusicCondition> musicConditions;
    public static boolean enabled;

    public MusicClient(CharmModule module) {
        this.module = module;
        enabled = module.enabled;
        if (MusicImprovements.playCreativeMusic) {
            this.addCreativeMusicCondition();
        }
        UseBlockCallback.EVENT.register(this::handleUseBlock);
        PlaySoundCallback.EVENT.register(this::handlePlaySound);
        ClientTickEvents.END_CLIENT_TICK.register(this::handleClientTick);
    }

    private class_1269 handleUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        this.stopRecord((class_1297)player, hitResult.method_17777(), player.method_5998(hand));
        return class_1269.field_5811;
    }

    private void handlePlaySound(class_1140 soundSystem, class_1113 sound) {
        this.checkShouldStopMusic(sound);
    }

    private void handleClientTick(class_310 client) {
        this.checkActuallyStopMusic();
    }

    public void addCreativeMusicCondition() {
        musicConditions.add(new MusicCondition(class_3417.field_14995, 1200, 3600, mc -> {
            if (mc.field_1724 == null) return false;
            if (mc.field_1724.method_7337()) {
                if (mc.field_1724.method_7325()) return false;
            }
            if (!DimensionHelper.isDimension(mc.field_1724.field_6002, new class_2960("overworld"))) return false;
            Random random = new Random();
            if (!(random.nextFloat() < 0.25f)) return false;
            return true;
        }));
    }

    public void stopRecord(class_1297 entity, class_2338 pos, class_1799 stack) {
        class_2680 state;
        if (entity.field_6002.field_9236 && entity instanceof class_1657 && stack.method_7909() instanceof class_1813 && (state = entity.field_6002.method_8320(pos)).method_26204() == class_2246.field_10223 && !((Boolean)state.method_11654((class_2769)class_2387.field_11180)).booleanValue()) {
            SoundHelper.getSoundManager().method_4875(null, class_3419.field_15253);
        }
    }

    public void checkShouldStopMusic(class_1113 sound) {
        if (sound.method_4774() == class_3419.field_15253) {
            SoundHelper.getPlayingSounds().forEach((category, s) -> {
                if (category == class_3419.field_15247) {
                    this.musicToStop = sound;
                    Charm.LOG.debug("Triggered background music while record playing");
                }
            });
        }
    }

    public void checkActuallyStopMusic() {
        if (this.musicToStop != null && ++this.ticksBeforeStop % 10 == 0) {
            SoundHelper.getSoundManager().method_4870(this.musicToStop);
            this.ticksBeforeStop = 0;
            this.musicToStop = null;
        }
    }

    public static boolean handleTick(class_1113 current) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return false;
        }
        MusicCondition ambient = MusicClient.getMusicCondition();
        if (currentMusic != null) {
            if (!DimensionHelper.isDimension((class_1937)mc.field_1687, currentDim)) {
                MusicClient.forceStop();
            }
            if (!mc.method_1483().method_4877(currentMusic)) {
                currentMusic = null;
                timeUntilNextMusic = Math.min(class_3532.method_15395((Random)new Random(), (int)ambient.getMinDelay(), (int)3600), timeUntilNextMusic);
            }
        }
        timeUntilNextMusic = Math.min(timeUntilNextMusic, ambient.getMaxDelay());
        if (currentMusic == null && timeUntilNextMusic-- <= 0) {
            currentDim = DimensionHelper.getDimension((class_1937)mc.field_1687);
            currentMusic = class_1109.method_4759((class_3414)ambient.getSound());
            if (currentMusic.method_4776() != class_1144.field_5592) {
                mc.method_1483().method_4873(currentMusic);
                timeUntilNextMusic = Integer.MAX_VALUE;
            }
        }
        return true;
    }

    public static boolean handleStop() {
        if (currentMusic != null) {
            class_310.method_1551().method_1483().method_4870(currentMusic);
            currentMusic = null;
            timeUntilNextMusic = 0;
        }
        return true;
    }

    public static boolean handlePlaying(class_5195 music) {
        return currentMusic != null && music.method_27279().method_14833().equals((Object)currentMusic.method_4775());
    }

    public static void forceStop() {
        class_310.method_1551().method_1483().method_4870(currentMusic);
        currentMusic = null;
        timeUntilNextMusic = 3600;
    }

    public static MusicCondition getMusicCondition() {
        MusicCondition condition = null;
        for (MusicCondition c : musicConditions) {
            if (!c.handle()) continue;
            condition = c;
            break;
        }
        if (condition == null) {
            condition = new MusicCondition(class_310.method_1551().method_1544());
        }
        return condition;
    }

    public static List<MusicCondition> getMusicConditions() {
        return musicConditions;
    }

    static {
        currentDim = null;
        timeUntilNextMusic = 100;
        musicConditions = new ArrayList<MusicCondition>();
    }
}

