/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.client;

import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendereregistry.v1.BlockEntityRendererRegistry;
import net.minecraft.class_1059;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2745;
import net.minecraft.class_2960;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.enums.IVariantMaterial;
import svenhjol.charm.block.VariantChestBlock;
import svenhjol.charm.block.VariantTrappedChestBlock;
import svenhjol.charm.blockentity.VariantChestBlockEntity;
import svenhjol.charm.blockentity.VariantTrappedChestBlockEntity;
import svenhjol.charm.event.BlockItemRenderCallback;
import svenhjol.charm.event.TextureStitchCallback;
import svenhjol.charm.module.VariantChests;
import svenhjol.charm.render.VariantChestBlockEntityRenderer;

@Environment(value=EnvType.CLIENT)
public class VariantChestClient {
    private final CharmModule module;
    private final VariantChestBlockEntity CACHED_NORMAL_CHEST = new VariantChestBlockEntity();
    private final VariantTrappedChestBlockEntity CACHED_TRAPPED_CHEST = new VariantTrappedChestBlockEntity();

    public VariantChestClient(CharmModule module) {
        this.module = module;
        BlockEntityRendererRegistry.INSTANCE.register(VariantChests.NORMAL_BLOCK_ENTITY, VariantChestBlockEntityRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(VariantChests.TRAPPED_BLOCK_ENTITY, VariantChestBlockEntityRenderer::new);
        TextureStitchCallback.EVENT.register(this::handleTextureStitch);
        BlockItemRenderCallback.EVENT.register(this::handleBlockItemRender);
    }

    private void handleTextureStitch(class_1059 atlas, Set<class_2960> textures) {
        if (atlas.method_24106().toString().equals("minecraft:textures/atlas/chest.png")) {
            VariantChests.NORMAL_CHEST_BLOCKS.keySet().forEach(type -> {
                this.addChestTexture(textures, (IVariantMaterial)type, class_2745.field_12574);
                this.addChestTexture(textures, (IVariantMaterial)type, class_2745.field_12571);
                this.addChestTexture(textures, (IVariantMaterial)type, class_2745.field_12569);
            });
        }
    }

    private class_2586 handleBlockItemRender(class_2248 block) {
        if (block instanceof VariantChestBlock) {
            VariantChestBlock chest = (VariantChestBlock)block;
            this.CACHED_NORMAL_CHEST.setMaterialType(chest.getMaterialType());
            return this.CACHED_NORMAL_CHEST;
        }
        if (block instanceof VariantTrappedChestBlock) {
            VariantTrappedChestBlock chest = (VariantTrappedChestBlock)block;
            this.CACHED_TRAPPED_CHEST.setMaterialType(chest.getMaterialType());
            return this.CACHED_TRAPPED_CHEST;
        }
        return null;
    }

    private void addChestTexture(Set<class_2960> textures, IVariantMaterial variant, class_2745 chestType) {
        String[] bases;
        String chestTypeName = chestType != class_2745.field_12569 ? "_" + chestType.method_15434().toLowerCase() : "";
        for (String base : bases = new String[]{"trapped", "normal"}) {
            class_2960 id = new class_2960(this.module.mod, "entity/chest/" + variant.method_15434() + "_" + base + chestTypeName);
            VariantChestBlockEntityRenderer.addTexture(variant, chestType, id, base.equals("trapped"));
            textures.add(id);
        }
    }
}

