/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1480;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2297;
import net.minecraft.class_2298;
import net.minecraft.class_2301;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import svenhjol.charm.module.CoralSquids;

public class CoralSquidEntity
extends class_1480 {
    public static final String CORAL_SQUID_TYPE_TAG = "CoralSquidType";
    private static final class_2940<Integer> CORAL_SQUID_TYPE = class_2945.method_12791(CoralSquidEntity.class, (class_2941)class_2943.field_13327);
    public static final Map<Integer, class_2960> TEXTURES = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(0, new class_2960("charm", "textures/entity/coral_squid/tube.png"));
        map.put(1, new class_2960("charm", "textures/entity/coral_squid/brain.png"));
        map.put(2, new class_2960("charm", "textures/entity/coral_squid/bubble.png"));
        map.put(3, new class_2960("charm", "textures/entity/coral_squid/fire.png"));
        map.put(4, new class_2960("charm", "textures/entity/coral_squid/horn.png"));
    });
    public static final Map<Integer, class_1792> DROPS = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(0, class_1802.field_8847);
        map.put(1, class_1802.field_8616);
        map.put(2, class_1802.field_8538);
        map.put(3, class_1802.field_8546);
        map.put(4, class_1802.field_8723);
    });
    public float tiltAngle;
    public float prevTiltAngle;
    public float rollAngle;
    public float prevRollAngle;
    public float thrustTimer;
    public float prevThrustTimer;
    public float tentacleAngle;
    public float prevTentacleAngle;
    private float swimVelocityScale;
    private float thrustTimerSpeed;
    private float turningSpeed;
    private float swimX;
    private float swimY;
    private float swimZ;

    public CoralSquidEntity(class_1299<? extends CoralSquidEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5974.setSeed(this.method_5628());
        this.thrustTimerSpeed = 1.0f / (this.field_5974.nextFloat() + 1.0f) * 0.28f;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
        this.setCoralSquidType(this.field_5974.nextInt(5));
        return entityData;
    }

    public boolean method_5957(class_4538 world) {
        if (!world.method_8320(this.method_24515().method_10084()).method_27852(class_2246.field_10382)) {
            return false;
        }
        class_238 box = this.method_5829().method_1009(5.0, 30.0, 5.0);
        class_2338 pos1 = new class_2338(box.field_1323, box.field_1322, box.field_1321);
        class_2338 pos2 = new class_2338(box.field_1320, box.field_1325, box.field_1324);
        return class_2338.method_20437((class_2338)pos1, (class_2338)pos2).anyMatch(p -> {
            class_2680 state = world.method_8320(p);
            return state.method_26204() instanceof class_2301 || state.method_26204() instanceof class_2298 || state.method_26204() instanceof class_2297;
        });
    }

    public int method_5945() {
        return 8;
    }

    public class_2960 getTexture() {
        return TEXTURES.getOrDefault(this.getCoralSquidType(), TEXTURES.get(0));
    }

    public int getCoralSquidType() {
        return (Integer)this.field_6011.method_12789(CORAL_SQUID_TYPE);
    }

    public void setCoralSquidType(int type) {
        if (type < 0 || type > 4) {
            type = this.field_5974.nextInt(5);
        }
        this.field_6011.method_12778(CORAL_SQUID_TYPE, (Object)type);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CORAL_SQUID_TYPE, (Object)1);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569(CORAL_SQUID_TYPE_TAG, this.getCoralSquidType());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setCoralSquidType(tag.method_10550(CORAL_SQUID_TYPE_TAG));
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SwimGoal(this));
        this.field_6201.method_6277(1, (class_1352)new EscapeAttackerGoal());
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1657 && (double)this.field_5974.nextFloat() < CoralSquids.dropChance) {
            this.method_5706((class_1935)DROPS.get(this.getCoralSquidType()));
        }
    }

    public static class_5132.class_5133 createSquidAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 5.0);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.5f;
    }

    protected class_3414 method_5994() {
        return class_3417.field_15034;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15212;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15124;
    }

    protected float method_6107() {
        return 0.4f;
    }

    protected float method_6017() {
        return 1.0f;
    }

    protected boolean method_5658() {
        return false;
    }

    public void method_6007() {
        super.method_6007();
        this.prevTiltAngle = this.tiltAngle;
        this.prevRollAngle = this.rollAngle;
        this.prevThrustTimer = this.thrustTimer;
        this.prevTentacleAngle = this.tentacleAngle;
        this.thrustTimer += this.thrustTimerSpeed;
        if ((double)this.thrustTimer > Math.PI * 2) {
            if (this.field_6002.field_9236) {
                this.thrustTimer = (float)Math.PI * 2;
            } else {
                this.thrustTimer = (float)((double)this.thrustTimer - Math.PI * 2);
                if (this.field_5974.nextInt(7) == 0) {
                    this.thrustTimerSpeed = 1.0f / (this.field_5974.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_6002.method_8421((class_1297)this, (byte)19);
            }
        }
        if (this.method_5816()) {
            if (this.thrustTimer < (float)Math.PI) {
                float f = this.thrustTimer / (float)Math.PI;
                this.tentacleAngle = class_3532.method_15374((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.swimVelocityScale = 1.0f;
                    this.turningSpeed = 1.0f;
                } else {
                    this.turningSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.swimVelocityScale *= 0.9f;
                this.turningSpeed *= 0.99f;
            }
            if (!this.field_6002.field_9236) {
                this.method_18800(this.swimX * this.swimVelocityScale, this.swimY * this.swimVelocityScale, this.swimZ * this.swimVelocityScale);
            }
            class_243 vec3d = this.method_18798();
            float g = class_3532.method_15368((double)CoralSquidEntity.method_17996((class_243)vec3d));
            this.field_6283 += (-((float)class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350)) * 57.295776f - this.field_6283) * 0.1f;
            this.field_6031 = this.field_6283;
            this.rollAngle = (float)((double)this.rollAngle + Math.PI * (double)this.turningSpeed * 1.5);
            this.tiltAngle += (-((float)class_3532.method_15349((double)g, (double)vec3d.field_1351)) * 57.295776f - this.tiltAngle) * 0.1f;
        } else {
            this.tentacleAngle = class_3532.method_15379((float)class_3532.method_15374((float)this.thrustTimer)) * (float)Math.PI * 0.25f;
            if (!this.field_6002.field_9236) {
                double d = this.method_18798().field_1351;
                if (this.method_6059(class_1294.field_5902)) {
                    d = 0.05 * (double)(this.method_6112(class_1294.field_5902).method_5578() + 1);
                } else if (!this.method_5740()) {
                    d -= 0.08;
                }
                this.method_18800(0.0, d * 0.981, 0.0);
            }
            this.tiltAngle = (float)((double)this.tiltAngle + (double)(-90.0f - this.tiltAngle) * 0.02);
        }
    }

    public void method_6091(class_243 movementInput) {
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte status) {
        if (status == 19) {
            this.thrustTimer = 0.0f;
        } else {
            super.method_5711(status);
        }
    }

    public void setSwimmingVector(float x, float y, float z) {
        this.swimX = x;
        this.swimY = y;
        this.swimZ = z;
    }

    public boolean hasSwimmingVector() {
        return this.swimX != 0.0f || this.swimY != 0.0f || this.swimZ != 0.0f;
    }

    static class SwimGoal
    extends class_1352 {
        private final CoralSquidEntity squid;

        public SwimGoal(CoralSquidEntity squid) {
            this.squid = squid;
        }

        public boolean method_6264() {
            return true;
        }

        public void method_6268() {
            int i = this.squid.method_6131();
            if (i > 100) {
                this.squid.setSwimmingVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.method_6051().nextInt(50) == 0 || !this.squid.field_5957 || !this.squid.hasSwimmingVector()) {
                float f = this.squid.method_6051().nextFloat() * ((float)Math.PI * 2);
                float g = class_3532.method_15362((float)f) * 0.2f;
                float h = -0.1f + this.squid.method_6051().nextFloat() * 0.2f;
                float j = class_3532.method_15374((float)f) * 0.2f;
                this.squid.setSwimmingVector(g, h, j);
            }
        }
    }

    class EscapeAttackerGoal
    extends class_1352 {
        private int timer;

        private EscapeAttackerGoal() {
        }

        public boolean method_6264() {
            class_1309 livingEntity = CoralSquidEntity.this.method_6065();
            if (CoralSquidEntity.this.method_5799() && livingEntity != null) {
                return CoralSquidEntity.this.method_5858((class_1297)livingEntity) < 100.0;
            }
            return false;
        }

        public void method_6269() {
            this.timer = 0;
        }

        public void method_6268() {
            ++this.timer;
            class_1309 livingEntity = CoralSquidEntity.this.method_6065();
            if (livingEntity != null) {
                class_243 vec3d = new class_243(CoralSquidEntity.this.method_23317() - livingEntity.method_23317(), CoralSquidEntity.this.method_23318() - livingEntity.method_23318(), CoralSquidEntity.this.method_23321() - livingEntity.method_23321());
                class_2680 blockState = CoralSquidEntity.this.field_6002.method_8320(new class_2338(CoralSquidEntity.this.method_23317() + vec3d.field_1352, CoralSquidEntity.this.method_23318() + vec3d.field_1351, CoralSquidEntity.this.method_23321() + vec3d.field_1350));
                class_3610 fluidState = CoralSquidEntity.this.field_6002.method_8316(new class_2338(CoralSquidEntity.this.method_23317() + vec3d.field_1352, CoralSquidEntity.this.method_23318() + vec3d.field_1351, CoralSquidEntity.this.method_23321() + vec3d.field_1350));
                if (fluidState.method_15767((class_3494)class_3486.field_15517) || blockState.method_26215()) {
                    double d = vec3d.method_1033();
                    if (d > 0.0) {
                        vec3d.method_1029();
                        float f = 3.0f;
                        if (d > 5.0) {
                            f = (float)((double)f - (d - 5.0) / 5.0);
                        }
                        if (f > 0.0f) {
                            vec3d = vec3d.method_1021((double)f);
                        }
                    }
                    if (blockState.method_26215()) {
                        vec3d = vec3d.method_1023(0.0, vec3d.field_1351, 0.0);
                    }
                    CoralSquidEntity.this.setSwimmingVector((float)vec3d.field_1352 / 20.0f, (float)vec3d.field_1351 / 20.0f, (float)vec3d.field_1350 / 20.0f);
                }
                if (this.timer % 10 == 5) {
                    CoralSquidEntity.this.field_6002.method_8406((class_2394)class_2398.field_11247, CoralSquidEntity.this.method_23317(), CoralSquidEntity.this.method_23318(), CoralSquidEntity.this.method_23321(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

